/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;

public class PropertyDialogAction
extends SelectionProviderAction {
    private IShellProvider shellProvider;
    private String initialPageId;

    public PropertyDialogAction(Shell shell, ISelectionProvider provider) {
        this(new SameShellProvider(shell), provider);
    }

    public PropertyDialogAction(IShellProvider shell, ISelectionProvider provider) {
        super(provider, WorkbenchMessages.PropertyDialog_text);
        Assert.isNotNull(shell);
        this.shellProvider = shell;
        this.setToolTipText(WorkbenchMessages.PropertyDialog_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, "org.eclipse.ui.property_dialog_action_context");
    }

    private boolean hasPropertyPagesFor(Object object) {
        PropertyPageContributorManager manager = PropertyPageContributorManager.getManager();
        return manager.hasContributorsFor(object);
    }

    public boolean isApplicableForSelection() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.isApplicableForSelection(this.getStructuredSelection());
    }

    public boolean isApplicableForSelection(IStructuredSelection selection) {
        return selection.size() == 1 && this.hasPropertyPagesFor(selection.getFirstElement());
    }

    public void run() {
        PreferenceDialog dialog = this.createDialog();
        if (dialog != null) {
            dialog.open();
        }
    }

    public PreferenceDialog createDialog() {
        IAdaptable element = (IAdaptable)this.getStructuredSelection().getFirstElement();
        if (element == null) {
            return null;
        }
        return PropertyDialog.createDialogOn(this.shellProvider.getShell(), this.initialPageId, element);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection.size() == 1 && selection.getFirstElement() != null);
    }
}

