/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ShowViewDialog;
import org.eclipse.ui.views.IViewDescriptor;

public final class ShowViewHandler
extends AbstractHandler {
    private static final String PARAMETER_NAME_VIEW_ID = "org.eclipse.ui.views.showView.viewId";
    private boolean makeFast = false;

    public ShowViewHandler() {
    }

    public ShowViewHandler(boolean makeFast) {
        this.makeFast = makeFast;
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        Map parameters = event.getParameters();
        Object value = parameters.get(PARAMETER_NAME_VIEW_ID);
        if (value == null) {
            this.openOther();
        } else {
            try {
                this.openView((String)value);
            }
            catch (PartInitException e) {
                throw new ExecutionException("Part could not be initialized", (Throwable)e);
            }
        }
        return null;
    }

    private final void openOther() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ShowViewDialog dialog = new ShowViewDialog(window.getShell(), WorkbenchPlugin.getDefault().getViewRegistry());
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        IViewDescriptor[] descriptors = dialog.getSelection();
        int i = 0;
        while (i < descriptors.length) {
            try {
                this.openView(descriptors[i].getId());
            }
            catch (PartInitException e) {
                ErrorDialog.openError(window.getShell(), WorkbenchMessages.ShowView_errorTitle, e.getMessage(), e.getStatus());
            }
            ++i;
        }
    }

    private final void openView(String viewId) throws PartInitException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        if (this.makeFast) {
            WorkbenchPage wp = (WorkbenchPage)activePage;
            IViewReference ref = wp.findViewReference(viewId);
            if (ref == null) {
                IViewPart part = wp.showView(viewId, null, 3);
                ref = (IViewReference)wp.getReference(part);
            }
            if (!wp.isFastView(ref)) {
                wp.addFastView(ref);
            }
            wp.activate(ref.getPart(true));
        } else {
            activePage.showView(viewId);
        }
    }
}

