/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.internal.OverlayIcon;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartTester;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.editorsupport.ComponentSupport;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.internal.part.services.NullActionBars;
import org.eclipse.ui.internal.part.services.NullEditorInput;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IWorkbenchPartOrientation;
import org.eclipse.ui.part.MultiEditor;
import org.eclipse.ui.part.MultiEditorInput;
import org.eclipse.ui.presentations.IPresentablePart;

public class EditorReference
extends WorkbenchPartReference
implements IEditorReference {
    private final EditorManager manager;
    private IMemento editorMemento;
    private boolean expectingInputChange = false;
    private boolean reportedMalfunctioningEditor = false;
    String name;
    String factoryId;
    IEditorInput restoredInput;
    private IEditorReference[] multiEditorChildren = null;

    public EditorReference(EditorManager manager, IEditorInput input, EditorDescriptor desc) {
        this.manager = manager;
        this.initListenersAndHandlers();
        this.restoredInput = input;
        this.init(desc.getId(), desc.getLabel(), "", desc.getImageDescriptor(), desc.getLabel(), "");
    }

    EditorReference(EditorManager manager, IMemento memento) {
        String location;
        this.manager = manager;
        this.initListenersAndHandlers();
        this.editorMemento = memento;
        String id = memento.getString("id");
        String title = memento.getString("title");
        String tooltip = Util.safeString(memento.getString("tooltip"));
        String partName = memento.getString("partName");
        if (partName == null) {
            partName = title;
        }
        EditorDescriptor desc = null;
        if (id != null) {
            desc = this.getDescriptor(id);
        }
        Path path = (location = memento.getString("path")) == null ? null : new Path(location);
        ImageDescriptor iDesc = this.manager.findImage(desc, path);
        this.name = memento.getString("name");
        if (this.name == null) {
            this.name = title;
        }
        this.setPinned("true".equals(memento.getString("pinned")));
        IMemento inputMem = memento.getChild("input");
        if (inputMem != null) {
            this.factoryId = inputMem.getString("factoryID");
        }
        this.init(id, title, tooltip, iDesc, partName, "");
    }

    public EditorDescriptor getDescriptor() {
        return this.getDescriptor(this.getId());
    }

    private EditorDescriptor getDescriptor(String id) {
        IEditorRegistry reg = WorkbenchPlugin.getDefault().getEditorRegistry();
        EditorDescriptor desc = (EditorDescriptor)reg.findEditor(id);
        return desc;
    }

    private void initListenersAndHandlers() {
        this.manager.checkCreateEditorPropListener();
        this.manager.checkCreatePinEditorShortcutKeyHandler();
    }

    protected PartPane createPane() {
        return new EditorPane(this, this.manager.page, this.manager.editorPresentation.getActiveWorkbook());
    }

    public void pinStatusUpdated() {
        IPresentablePart iPresPart;
        PartPane partPane = this.getPane();
        EditorPane editorPane = null;
        if (partPane instanceof EditorPane && (iPresPart = (editorPane = (EditorPane)partPane).getPresentablePart()) instanceof PresentablePart) {
            ((PresentablePart)iPresPart).firePropertyChange(1);
        }
    }

    public String getFactoryId() {
        IEditorPart editor = this.getEditor(false);
        if (editor != null) {
            IPersistableElement persistable = editor.getEditorInput().getPersistable();
            if (persistable != null) {
                return persistable.getFactoryId();
            }
            return null;
        }
        return this.factoryId;
    }

    protected String computePartName() {
        if (this.part instanceof IWorkbenchPart2) {
            return super.computePartName();
        }
        return this.getRawTitle();
    }

    public String getName() {
        if (this.part != null) {
            return this.getEditor(false).getEditorInput().getName();
        }
        return this.name;
    }

    public IEditorPart getEditor(boolean restore) {
        return (IEditorPart)this.getPart(restore);
    }

    protected void releaseReferences() {
        super.releaseReferences();
        this.editorMemento = null;
        this.name = null;
        this.factoryId = null;
        this.restoredInput = null;
    }

    void setName(String name) {
        this.name = name;
    }

    public IMemento getMemento() {
        return this.editorMemento;
    }

    public boolean isDirty() {
        if (this.part == null) {
            return false;
        }
        return ((IEditorPart)this.part).isDirty();
    }

    public IWorkbenchPage getPage() {
        return this.manager.page;
    }

    protected void doDisposePart() {
        if (this.multiEditorChildren != null) {
            int i = 0;
            while (i < this.multiEditorChildren.length) {
                EditorReference ref = (EditorReference)this.multiEditorChildren[i];
                if (ref != null) {
                    ref.dispose();
                }
                ++i;
            }
            this.multiEditorChildren = null;
        }
        if (this.part != null) {
            EditorSite site = (EditorSite)((IEditorPart)this.part).getEditorSite();
            this.manager.disposeEditorActionBars((EditorActionBars)site.getActionBars());
            site.dispose();
        }
        this.manager.checkDeleteEditorResources();
        super.doDisposePart();
        this.editorMemento = null;
        this.restoredInput = new NullEditorInput();
    }

    public IEditorInput getEditorInput() throws PartInitException {
        if (this.isDisposed()) {
            if (!(this.restoredInput instanceof NullEditorInput)) {
                this.restoredInput = new NullEditorInput();
            }
            return this.restoredInput;
        }
        IEditorPart part = this.getEditor(false);
        if (part != null) {
            return part.getEditorInput();
        }
        return this.getRestoredInput();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IEditorInput getRestoredInput() throws PartInitException {
        if (this.restoredInput != null) {
            return this.restoredInput;
        }
        IMemento editorMem = this.getMemento();
        if (editorMem == null) {
            throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_no_persisted_state, this.getId(), this.getName()));
        }
        IMemento inputMem = editorMem.getChild("input");
        String factoryID = null;
        if (inputMem != null) {
            factoryID = inputMem.getString("factoryID");
        }
        if (factoryID == null) {
            throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_no_input_factory_ID, this.getId(), this.getName()));
        }
        IAdaptable input = null;
        String label = null;
        if (UIStats.isDebugging(6)) {
            label = this.getName() != null ? this.getName() : factoryID;
        }
        try {
            UIStats.start(6, label);
            IElementFactory factory = PlatformUI.getWorkbench().getElementFactory(factoryID);
            if (factory == null) {
                throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_bad_element_factory, new Object[]{factoryID, this.getId(), this.getName()}));
            }
            input = factory.createElement(inputMem);
            if (input == null) {
                throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_create_element_returned_null, new Object[]{factoryID, this.getId(), this.getName()}));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            UIStats.end(6, input, label);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        UIStats.end(6, input, label);
        if (!(input instanceof IEditorInput)) {
            throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_wrong_createElement_result, new Object[]{factoryID, this.getId(), this.getName()}));
        }
        this.restoredInput = (IEditorInput)input;
        return this.restoredInput;
    }

    public ImageDescriptor computeImageDescriptor() {
        ImageDescriptor descriptor = super.computeImageDescriptor();
        if (!this.isPinned()) {
            return descriptor;
        }
        IPreferenceStore prefStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        boolean bUsePin = prefStore.getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!bUsePin) {
            return descriptor;
        }
        ImageDescriptor pinDesc = this.manager.getEditorPinImageDesc();
        if (pinDesc == null) {
            return descriptor;
        }
        return new OverlayIcon(descriptor, pinDesc, new Point(16, 16));
    }

    protected IWorkbenchPart createPart() {
        PartInitException exception = null;
        IEditorPart result = null;
        try {
            result = this.createPartHelper();
        }
        catch (PartInitException e) {
            exception = e;
        }
        if (exception != null) {
            IEditorInput input;
            IStatus originalStatus = exception.getStatus();
            IStatus logStatus = StatusUtil.newStatus(originalStatus, NLS.bind("Unable to create editor ID {0}: {1}", this.getId(), originalStatus.getMessage()));
            WorkbenchPlugin.log(logStatus);
            IStatus displayStatus = StatusUtil.newStatus(originalStatus, NLS.bind(WorkbenchMessages.EditorManager_unableToCreateEditor, originalStatus.getMessage()));
            ErrorEditorPart part = new ErrorEditorPart(displayStatus);
            try {
                input = this.getEditorInput();
            }
            catch (PartInitException partInitException) {
                input = new NullEditorInput();
            }
            EditorPane pane = (EditorPane)this.getPane();
            pane.createControl((Composite)this.manager.page.getEditorPresentation().getLayoutPart().getControl());
            EditorDescriptor descr = this.getDescriptor();
            EditorSite site = new EditorSite(this, part, this.manager.page, descr);
            site.setActionBars(new EditorActionBars(new NullActionBars(), this.getId()));
            try {
                part.init(site, input);
            }
            catch (PartInitException e) {
                WorkbenchPlugin.log(e);
                return null;
            }
            Composite parent = (Composite)pane.getControl();
            Composite content = new Composite(parent, 0);
            content.setLayout(new FillLayout());
            try {
                part.createPartControl(content);
            }
            catch (Exception e) {
                content.dispose();
                WorkbenchPlugin.log(e);
                return null;
            }
            result = part;
        }
        return result;
    }

    protected void partPropertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.expectingInputChange = false;
        }
        super.partPropertyChanged(source, propId);
    }

    public boolean setInput(IEditorInput input) {
        if (this.part != null) {
            if (this.part instanceof IReusableEditor) {
                IReusableEditor editor = (IReusableEditor)this.part;
                this.expectingInputChange = true;
                editor.setInput(input);
                if (this.expectingInputChange) {
                    this.reportMalfunction("Editor is not firing a PROP_INPUT event in response to IReusableEditor.setInput(...)");
                    this.firePropertyChange(258);
                }
                return editor.getEditorInput() == input;
            }
            return false;
        }
        if (input != this.restoredInput) {
            this.restoredInput = input;
            this.firePropertyChange(258);
        }
        return true;
    }

    private void reportMalfunction(String string) {
        if (!this.reportedMalfunctioningEditor) {
            this.reportedMalfunctioningEditor = true;
            String errorMessage = "Problem detected with part " + this.getId();
            if (this.part != null) {
                errorMessage = String.valueOf(errorMessage) + " (class = " + this.part.getClass().getName() + ")";
            }
            errorMessage = String.valueOf(errorMessage) + ": " + string;
            WorkbenchPlugin.log(StatusUtil.newStatus(this.getDescriptor().getPluginId(), errorMessage, null));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IEditorPart createPartHelper() throws PartInitException {
        Widget content = null;
        IWorkbenchPart initializedPart = null;
        EditorActionBars actionBars = null;
        EditorSite site = null;
        try {
            IEditorInput editorInput = this.getEditorInput();
            String editorID = this.getId();
            EditorDescriptor desc = this.getDescriptor();
            if (desc == null) {
                throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_missing_editor_descriptor, editorID));
            }
            IEditorPart part = null;
            if (desc.isInternal()) {
                try {
                    UIStats.start(0, editorID);
                    part = this.manager.createPart(desc);
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    UIStats.end(0, this, editorID);
                    throw throwable;
                }
                {
                    Object var9_18 = null;
                }
                UIStats.end(0, this, editorID);
                if (part != null && part instanceof MultiEditor) {
                    this.multiEditorChildren = this.manager.openMultiEditor(this, (MultiEditor)part, (MultiEditorInput)editorInput);
                }
            } else {
                if (!desc.getId().equals("org.eclipse.ui.systemInPlaceEditor")) throw new PartInitException(NLS.bind(WorkbenchMessages.EditorManager_invalid_editor_descriptor, editorID));
                part = ComponentSupport.getSystemInPlaceEditor();
                if (part == null) {
                    throw new PartInitException(WorkbenchMessages.EditorManager_no_in_place_support);
                }
            }
            PartPane pane = this.getPane();
            pane.createControl((Composite)this.manager.page.getEditorPresentation().getLayoutPart().getControl());
            int style = 0;
            if (part instanceof IWorkbenchPartOrientation) {
                style = ((IWorkbenchPartOrientation)((Object)part)).getOrientation();
            }
            site = this.manager.createSite(this, part, desc, editorInput);
            actionBars = (EditorActionBars)site.getActionBars();
            Composite parent = (Composite)pane.getControl();
            content = new Composite(parent, style);
            ((Composite)content).setLayout(new FillLayout());
            try {
                UIStats.start(1, editorID);
                part.createPartControl((Composite)content);
                parent.layout(true);
            }
            catch (Throwable throwable) {
                Object var12_21 = null;
                UIStats.end(1, part, editorID);
                throw throwable;
            }
            {
                Object var12_22 = null;
            }
            UIStats.end(1, part, editorID);
            PartTester.testEditor(part);
            return part;
        }
        catch (Exception e) {
            if (content != null) {
                try {
                    content.dispose();
                }
                catch (RuntimeException re) {
                    WorkbenchPlugin.log(re);
                }
            }
            if (initializedPart != null) {
                try {
                    initializedPart.dispose();
                }
                catch (RuntimeException re) {
                    WorkbenchPlugin.log(re);
                }
            }
            if (actionBars != null) {
                try {
                    this.manager.disposeEditorActionBars(actionBars);
                }
                catch (RuntimeException re) {
                    WorkbenchPlugin.log(re);
                }
            }
            if (site == null) throw new PartInitException(StatusUtil.getLocalizedMessage(e), StatusUtil.getCause(e));
            try {
                site.dispose();
                throw new PartInitException(StatusUtil.getLocalizedMessage(e), StatusUtil.getCause(e));
            }
            catch (RuntimeException re) {
                WorkbenchPlugin.log(re);
            }
            throw new PartInitException(StatusUtil.getLocalizedMessage(e), StatusUtil.getCause(e));
        }
    }

    public boolean isMultiReference() {
        return this.multiEditorChildren != null || this.restoredInput instanceof MultiEditorInput;
    }
}

