/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.util.ILogger;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.internal.PlatformUIPreferenceListener;
import org.eclipse.ui.internal.WorkbenchPlugin;

final class JFaceUtil {
    private JFaceUtil() {
    }

    public static void initializeJFace() {
        SafeRunnable.setRunner(new ISafeRunnableRunner(){

            public void run(ISafeRunnable code) {
                Platform.run(code);
            }
        });
        Policy.setLog(new ILogger(){

            public void log(IStatus status) {
                WorkbenchPlugin.getDefault().getLog().log(status);
            }
        });
        if ("true".equalsIgnoreCase(Platform.getDebugOption("/debug"))) {
            Policy.DEBUG_DIALOG_NO_PARENT = "true".equalsIgnoreCase(Platform.getDebugOption("org.eclipse.jface/debug/dialog/noparent"));
            Policy.TRACE_ACTIONS = "true".equalsIgnoreCase(Platform.getDebugOption("org.eclipse.jface/trace/actions"));
            Policy.TRACE_TOOLBAR = "true".equalsIgnoreCase(Platform.getDebugOption("org.eclipse.jface/trace/toolbarDisposal"));
        }
    }

    public static void initializeJFacePreferences() {
        IEclipsePreferences rootNode = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
        final String workbenchName = WorkbenchPlugin.getDefault().getBundle().getSymbolicName();
        rootNode.addNodeChangeListener(new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
                if (!event.getChild().name().equals(workbenchName)) {
                    return;
                }
                ((IEclipsePreferences)event.getChild()).addPreferenceChangeListener(PlatformUIPreferenceListener.getSingleton());
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
            }
        });
        JFacePreferences.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
    }
}

