/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.layout.LayoutUtil;

public class PerspectiveBarManager
extends ToolBarManager {
    public static final String SMALL_FONT = "org.eclipse.ui.smallFont";
    private CoolBar coolBar;
    private Menu popup;

    public PerspectiveBarManager(int style) {
        super(style);
    }

    public ToolBar createControl(Composite parent) {
        ToolBar control2 = super.createControl(parent);
        if (control2 != null && !control2.isDisposed()) {
            control2.setFont(this.getFont());
        }
        return control2;
    }

    public PerspectiveBarManager(ToolBar toolbar) {
        super(toolbar);
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.setFont(this.getFont());
        }
    }

    public void handleChevron(SelectionEvent event) {
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
            return;
        }
        CoolItem item = (CoolItem)event.widget;
        ToolBar control2 = this.getControl();
        if (!(control2 instanceof ToolBar)) {
            return;
        }
        Rectangle itemBounds = item.getBounds();
        Point pt = this.coolBar.toDisplay(new Point(itemBounds.x, itemBounds.y));
        itemBounds.x = pt.x;
        itemBounds.y = pt.y;
        ToolBar toolBar = control2;
        ToolItem[] tools = toolBar.getItems();
        int toolCount = tools.length;
        int i = 0;
        while (i < toolCount) {
            Rectangle toolBounds = tools[i].getBounds();
            pt = toolBar.toDisplay(new Point(toolBounds.x, toolBounds.y));
            toolBounds.x = pt.x;
            toolBounds.y = pt.y;
            Rectangle intersection = itemBounds.intersection(toolBounds);
            if (!intersection.equals(toolBounds)) break;
            ++i;
        }
        this.popup = new Menu(this.coolBar);
        int j = i;
        while (j < toolCount) {
            ToolItem tool = tools[j];
            MenuItem menuItem = new MenuItem(this.popup, 0);
            if (tool.getSelection()) {
                menuItem.setEnabled(false);
            }
            if (tool.getData() instanceof PerspectiveBarContributionItem) {
                menuItem.setText(((PerspectiveBarContributionItem)tool.getData()).getPerspective().getLabel());
            } else {
                menuItem.setText(tool.getText());
            }
            menuItem.setImage(tool.getImage());
            menuItem.setData("IContributionItem", tool.getData());
            menuItem.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.widget;
                    Object item = menuItem.getData("IContributionItem");
                    if (item instanceof PerspectiveBarContributionItem) {
                        PerspectiveBarContributionItem contribItem = (PerspectiveBarContributionItem)item;
                        PerspectiveBarManager.this.update(false);
                        contribItem.select();
                    }
                }
            });
            ++j;
        }
        pt = this.coolBar.toDisplay(new Point(event.x, event.y));
        this.popup.setLocation(pt.x, pt.y);
        this.popup.setVisible(true);
        Display display = this.coolBar.getDisplay();
        while (this.popup != null && !this.popup.isDisposed() && this.popup.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.popup != null) {
            this.popup.dispose();
            this.popup = null;
        }
    }

    protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
        super.relayout(toolBar, oldCount, newCount);
        if (this.getControl() != null) {
            LayoutUtil.resize(this.getControl());
        }
    }

    void setParent(CoolBar cool) {
        this.coolBar = cool;
    }

    private Font getFont() {
        return JFaceResources.getFont(SMALL_FONT);
    }

    void select(PerspectiveBarContributionItem contribItem) {
        if (contribItem.getToolItem() == null) {
            return;
        }
        if (this.getControl().isVisible() && !this.isItemVisible(contribItem.getToolItem())) {
            this.ensureVisible(contribItem);
        }
    }

    public void addItem(PerspectiveBarContributionItem item) {
        this.insert(1, item);
        this.update(false);
    }

    public void removeItem(PerspectiveBarContributionItem item) {
        this.remove(item);
    }

    private void ensureVisible(PerspectiveBarContributionItem contribItem) {
        this.relocate(contribItem, 1);
    }

    void relocate(PerspectiveBarContributionItem contribItem, int index) {
        PerspectiveBarContributionItem newItem = new PerspectiveBarContributionItem(contribItem.getPerspective(), contribItem.getPage());
        this.removeItem(contribItem);
        contribItem.dispose();
        contribItem = null;
        this.insert(index, newItem);
        this.update(false);
    }

    private boolean isItemVisible(ToolItem toolItem) {
        Rectangle barBounds = this.getControl().getBounds();
        Rectangle itemBounds = toolItem.getBounds();
        return barBounds.intersection(itemBounds).equals(itemBounds);
    }

    public void arrangeToolbar() {
        if (!this.getControl().isVisible()) {
            return;
        }
        if (this.getControl().getItemCount() < 3) {
            return;
        }
        IContributionItem[] items = this.getItems();
        int i = 2;
        while (i < items.length) {
            PerspectiveBarContributionItem contribItem = (PerspectiveBarContributionItem)items[i];
            if (contribItem.getToolItem().getSelection() && !this.isItemVisible(contribItem.getToolItem())) {
                this.ensureVisible(contribItem);
                break;
            }
            ++i;
        }
    }
}

