/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class SaveableHelper {
    private static int AutomatedResponse = -1;

    public static void testSetAutomatedResponse(int response) {
        AutomatedResponse = response;
    }

    static boolean savePart(final ISaveablePart saveable, IWorkbenchPart part, IWorkbenchWindow window, boolean confirm) {
        if (!saveable.isDirty()) {
            return true;
        }
        if (confirm) {
            int choice = AutomatedResponse;
            if (choice == -1) {
                if (saveable instanceof ISaveablePart2) {
                    choice = ((ISaveablePart2)saveable).promptToSaveOnClose();
                }
                if (choice == -1 || choice == 3) {
                    String message = NLS.bind(WorkbenchMessages.EditorManager_saveChangesQuestion, part.getTitle());
                    String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    MessageDialog d = new MessageDialog(window.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, buttons, 0);
                    choice = d.open();
                }
            }
            switch (choice) {
                case 0: {
                    break;
                }
                case 1: {
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        IRunnableWithProgress progressOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                saveable.doSave(monitorWrap);
            }
        };
        return SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save, progressOp, window);
    }

    static boolean runProgressMonitorOperation(String opName, final IRunnableWithProgress progressOp, IWorkbenchWindow window) {
        IRunnableContext ctx = window instanceof ApplicationWindow ? window : new ProgressMonitorJobsDialog(window.getShell());
        final boolean[] wasCanceled = new boolean[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                progressOp.run(monitor);
                wasCanceled[0] = monitor.isCanceled();
            }
        };
        try {
            ctx.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            String title = NLS.bind(WorkbenchMessages.EditorManager_operationFailed, opName);
            Throwable targetExc = e.getTargetException();
            WorkbenchPlugin.log(title, new Status(2, "org.eclipse.ui", 0, title, targetExc));
            MessageDialog.openError(window.getShell(), WorkbenchMessages.Error, String.valueOf(title) + ':' + targetExc.getMessage());
        }
        catch (InterruptedException interruptedException) {
            wasCanceled[0] = true;
        }
        return !wasCanceled[0];
    }
}

