/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;
import org.eclipse.ui.internal.misc.Assert;

public class OpenPerspectiveDialogAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public OpenPerspectiveDialogAction(IWorkbenchWindow window) {
        Assert.isNotNull(window);
        this.workbenchWindow = window;
        this.setText(WorkbenchMessages.OpenPerspectiveDialogAction_text);
        this.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE"));
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        SelectPerspectiveDialog dlg = new SelectPerspectiveDialog(this.workbenchWindow.getShell(), this.workbenchWindow.getWorkbench().getPerspectiveRegistry());
        dlg.open();
        if (dlg.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor desc = dlg.getSelection();
        if (desc != null) {
            try {
                this.workbenchWindow.openPage(desc.getId(), null);
            }
            catch (WorkbenchException e) {
                WorkbenchPlugin.log("Error opening perspective ", e);
            }
        }
    }

    public void dispose() {
        this.workbenchWindow = null;
    }
}

