/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.Parameter;

final class CommandPersistence {
    private static final String ATTRIBUTE_CATEGORY = "category";
    private static final String ATTRIBUTE_CATEGORY_ID = "categoryId";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_OPTIONAL = "optional";
    private static final String ELEMENT_ACTION_DEFINITION = "actionDefinition";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_COMMAND = "command";
    private static final String ELEMENT_COMMAND_PARAMETER = "commandParameter";
    private static final String EXTENSION_ACTION_DEFINITIONS = "org.eclipse.ui.actionDefinitions";
    private static final String EXTENSION_COMMANDS = "org.eclipse.ui.commands";
    private static final int INDEX_CATEGORY_DEFINITIONS = 0;
    private static final int INDEX_COMMAND_DEFINITIONS = 1;
    private static boolean listenersAttached = false;

    private static final void addElementToIndexedArray(IConfigurationElement elementToAdd, IConfigurationElement[][] indexedArray, int index, int currentCount) {
        IConfigurationElement[] elements;
        if (currentCount == 0) {
            elements = new IConfigurationElement[1];
            indexedArray[index] = elements;
        } else if (currentCount >= indexedArray[index].length) {
            IConfigurationElement[] copy = new IConfigurationElement[indexedArray[index].length * 2];
            System.arraycopy(indexedArray[index], 0, copy, 0, currentCount);
            elements = copy;
            indexedArray[index] = elements;
        } else {
            elements = indexedArray[index];
        }
        elements[currentCount] = elementToAdd;
    }

    static final void read(final CommandManager commandManager) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int commandDefinitionCount = 0;
        int categoryDefinitionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[2][];
        IConfigurationElement[] commandsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_COMMANDS);
        int i = 0;
        while (i < commandsExtensionPoint.length) {
            IConfigurationElement configurationElement = commandsExtensionPoint[i];
            String name = configurationElement.getName();
            if (ELEMENT_COMMAND.equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, commandDefinitionCount++);
            } else if ("category".equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, categoryDefinitionCount++);
            }
            ++i;
        }
        IConfigurationElement[] actionDefinitionsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_ACTION_DEFINITIONS);
        int i2 = 0;
        while (i2 < actionDefinitionsExtensionPoint.length) {
            IConfigurationElement configurationElement = actionDefinitionsExtensionPoint[i2];
            String name = configurationElement.getName();
            if (ELEMENT_ACTION_DEFINITION.equals(name)) {
                CommandPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, commandDefinitionCount++);
            }
            ++i2;
        }
        CommandPersistence.readCategoriesFromCommandsExtensionPoint(indexedConfigurationElements[0], categoryDefinitionCount, commandManager);
        CommandPersistence.readCommandsFromCommandsExtensionPoint(indexedConfigurationElements[1], commandDefinitionCount, commandManager);
        if (!listenersAttached) {
            registry.addRegistryChangeListener(new IRegistryChangeListener(){

                public final void registryChanged(IRegistryChangeEvent event) {
                    IExtensionDelta[] actionDefinitionDeltas;
                    IExtensionDelta[] commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands");
                    if (commandDeltas.length == 0 && (actionDefinitionDeltas = event.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length == 0) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(this, commandManager){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ CommandManager val$commandManager;
                        {
                            this.this$1 = var1_1;
                            this.val$commandManager = commandManager;
                        }

                        public void run() {
                            CommandPersistence.read(this.val$commandManager);
                        }
                    });
                }
            }, "org.eclipse.ui");
            listenersAttached = true;
        }
    }

    private static final void readCategoriesFromCommandsExtensionPoint(IConfigurationElement[] configurationElements, int configurationElementCount, CommandManager commandManager) {
        Set categoryIds = commandManager.getDefinedCategoryIds();
        if (categoryIds != null) {
            Iterator categoryIdItr = categoryIds.iterator();
            Category[] categories = new Category[categoryIds.size()];
            int i = 0;
            while (categoryIdItr.hasNext()) {
                categories[i++] = commandManager.getCategory((String)categoryIdItr.next());
            }
            int j = 0;
            while (j < categories.length) {
                categories[j].undefine();
                ++j;
            }
        }
        ArrayList<Status> warningsToLog = null;
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String categoryId = configurationElement.getAttribute(ATTRIBUTE_ID);
            if (categoryId == null || categoryId.length() == 0) {
                String message = "Categories need an id: plug-in='" + configurationElement.getNamespace() + "'.";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                if (warningsToLog == null) {
                    warningsToLog = new ArrayList<Status>();
                }
                warningsToLog.add(status);
            } else {
                String name = configurationElement.getAttribute(ATTRIBUTE_NAME);
                if (name == null || name.length() == 0) {
                    String message = "Categories need a name: plug-in='" + configurationElement.getNamespace() + "', categoryId='" + categoryId + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    if (warningsToLog == null) {
                        warningsToLog = new ArrayList();
                    }
                    warningsToLog.add(status);
                } else {
                    String description = configurationElement.getAttribute(ATTRIBUTE_DESCRIPTION);
                    if (description != null && description.length() == 0) {
                        description = null;
                    }
                    Category category = commandManager.getCategory(categoryId);
                    category.define(name, description);
                }
            }
            ++i;
        }
        if (warningsToLog != null) {
            MultiStatus status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.", null);
            WorkbenchPlugin.log(status);
        }
    }

    private static final void readCommandsFromCommandsExtensionPoint(IConfigurationElement[] configurationElements, int configurationElementCount, CommandManager commandManager) {
        Set commandIds = commandManager.getDefinedCommandIds();
        if (commandIds != null) {
            Iterator commandIdItr = commandIds.iterator();
            Command[] commands = new Command[commandIds.size()];
            int i = 0;
            while (commandIdItr.hasNext()) {
                commands[i++] = commandManager.getCommand((String)commandIdItr.next());
            }
            int j = 0;
            while (j < commands.length) {
                commands[j].undefine();
                ++j;
            }
        }
        ArrayList<Status> warningsToLog = new ArrayList<Status>(1);
        int i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String commandId = configurationElement.getAttribute(ATTRIBUTE_ID);
            if (commandId == null || commandId.length() == 0) {
                String message = "Commands need an id: plug-in='" + configurationElement.getNamespace() + "'.";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                warningsToLog.add(status);
            } else {
                String name = configurationElement.getAttribute(ATTRIBUTE_NAME);
                if (name == null || name.length() == 0) {
                    String message = "Commands need a name: plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                } else {
                    String categoryId;
                    String description = configurationElement.getAttribute(ATTRIBUTE_DESCRIPTION);
                    if (description != null && description.length() == 0) {
                        description = null;
                    }
                    if (((categoryId = configurationElement.getAttribute(ATTRIBUTE_CATEGORY_ID)) == null || categoryId.length() == 0) && (categoryId = configurationElement.getAttribute("category")) == null) {
                        categoryId = "";
                    }
                    IParameter[] parameters = CommandPersistence.readParameters(configurationElement, warningsToLog);
                    Command command = commandManager.getCommand(commandId);
                    Category category = commandManager.getCategory(categoryId);
                    if (!category.isDefined()) {
                        String message = "Commands should really have a category, not categoryId='" + categoryId + "': plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                        Status status = new Status(1, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                    }
                    command.define(name, description, category, parameters);
                }
            }
            ++i;
        }
        if (!warningsToLog.isEmpty()) {
            MultiStatus status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.", null);
            WorkbenchPlugin.log(status);
        }
    }

    private static final Parameter[] readParameters(IConfigurationElement configurationElement, List warningsToLog) {
        IConfigurationElement[] parameterElements = configurationElement.getChildren(ELEMENT_COMMAND_PARAMETER);
        if (parameterElements == null || parameterElements.length == 0) {
            return null;
        }
        int insertionIndex = 0;
        Parameter[] parameters = new Parameter[parameterElements.length];
        int i = 0;
        while (i < parameterElements.length) {
            IConfigurationElement parameterElement = parameterElements[i];
            String id = parameterElement.getAttribute(ATTRIBUTE_ID);
            if (id == null || id.length() == 0) {
                String message = "Parameters need an id: plug-in='" + configurationElement.getNamespace() + "'.";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                warningsToLog.add(status);
            } else {
                String name = parameterElement.getAttribute(ATTRIBUTE_NAME);
                if (name == null || name.length() == 0) {
                    String message = "Parameters need a name: plug-in='" + configurationElement.getNamespace() + "', parameterId='" + id + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                } else {
                    String optionalString = parameterElement.getAttribute(ATTRIBUTE_OPTIONAL);
                    boolean optional = optionalString == null || optionalString.length() == 0 ? true : !"false".equalsIgnoreCase(optionalString);
                    Parameter parameter = new Parameter(id, name, parameterElement, optional);
                    parameters[insertionIndex++] = parameter;
                }
            }
            ++i;
        }
        if (insertionIndex != parameters.length) {
            Parameter[] compactedParameters = new Parameter[insertionIndex];
            System.arraycopy(parameters, 0, compactedParameters, 0, insertionIndex);
            parameters = compactedParameters;
        }
        return parameters;
    }

    private CommandPersistence() {
    }
}

