/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.components.ComponentMessages;
import org.eclipse.ui.internal.components.framework.ClassIdentifier;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ServiceFactory;
import org.eclipse.ui.internal.components.registry.ComponentRegistry;
import org.eclipse.ui.internal.components.registry.ComponentScope;
import org.eclipse.ui.internal.components.registry.ExtensionPointManager;
import org.eclipse.ui.internal.components.registry.IComponentScope;
import org.eclipse.ui.internal.components.registry.ServiceExtensionPoint;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.osgi.framework.Bundle;

public class ComponentUtil {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private static ComponentRegistry registry;
    private static ExtensionPointManager uiExtensionPoints;
    private static ServiceExtensionPoint partServices;

    static {
        uiExtensionPoints = null;
        partServices = null;
    }

    private ComponentUtil() {
    }

    public static ComponentRegistry getRegistry() {
        if (registry != null) {
            return registry;
        }
        registry = new ComponentRegistry();
        Bundle uiBundle = Platform.getBundle("org.eclipse.ui");
        uiExtensionPoints = new ExtensionPointManager(uiBundle);
        partServices = new ServiceExtensionPoint(uiExtensionPoints, registry);
        return registry;
    }

    public static void disposeRegistry() {
        if (partServices != null) {
            partServices.dispose();
            partServices = null;
        }
        if (uiExtensionPoints != null) {
            uiExtensionPoints.dispose();
            uiExtensionPoints = null;
        }
        registry = null;
    }

    public static String getSimpleClassName(String fullyQualifiedClassName) {
        int idx = fullyQualifiedClassName.lastIndexOf(46) + 1;
        return fullyQualifiedClassName.substring(idx, fullyQualifiedClassName.length());
    }

    public static Throwable getCause(Throwable toQuery) {
        return StatusUtil.getCause(toQuery);
    }

    public static Class loadClass(ClassIdentifier type) throws ComponentException {
        try {
            Bundle pluginBundle = Platform.getBundle(type.getNamespace());
            Class result = pluginBundle.loadClass(type.getTypeName());
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ComponentException(type.getTypeName(), NLS.bind(ComponentMessages.ComponentUtil_class_not_found, type.getNamespace(), type.getTypeName()), null);
        }
    }

    public static final ClassIdentifier getClassFromInitializationData(IConfigurationElement config, Object data) throws CoreException {
        if (!(data instanceof String)) {
            String msg = NLS.bind(ComponentMessages.ReflectionFactory_missing_data, config.toString());
            throw new CoreException(new Status(4, config.getNamespace(), 0, msg, null));
        }
        return new ClassIdentifier(config.getNamespace(), (String)data);
    }

    public static String getMessage(Throwable toQuery) {
        String msg = toQuery.getMessage();
        if (msg == null) {
            msg = toQuery.toString();
        }
        return msg;
    }

    public static String getAttribute(IConfigurationElement element, String attributeId) throws CoreException {
        String result = element.getAttribute(attributeId);
        if (result == null) {
            throw new CoreException(new Status(4, element.getNamespace(), 0, NLS.bind(ComponentMessages.ComponentUtil_missing_attribute, new Object[]{element.getName(), attributeId, element.getDeclaringExtension().getExtensionPointUniqueIdentifier()}), null));
        }
        return result;
    }

    public static Throwable getMostSpecificCause(Throwable exception) {
        return ComponentUtil.getMostSpecificException(ComponentUtil.getCause(exception));
    }

    private static Throwable getMostSpecificException(Throwable exception) {
        Throwable cause = ComponentUtil.getCause(exception);
        if (cause == null || cause == exception) {
            return exception;
        }
        return ComponentUtil.getMostSpecificException(cause);
    }

    public static Object createInstance(Class implementation) throws ComponentException {
        try {
            return implementation.newInstance();
        }
        catch (InstantiationException e) {
            throw new ComponentException(implementation, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ComponentException(implementation, (Throwable)e);
        }
    }

    public static IComponentScope getScope(String scope) {
        return ComponentUtil.getRegistry().getScope(scope);
    }

    public static ServiceFactory getContext(String scope) {
        IComponentScope s = ComponentUtil.getScope(scope);
        if (s == null) {
            return null;
        }
        return ((ComponentScope)s).getContext();
    }
}

