/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.expressions.Expression;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.ContextActivation;
import org.eclipse.ui.internal.contexts.ContextAuthority;
import org.eclipse.ui.internal.contexts.ContextPersistence;

public final class ContextService
implements IContextService {
    private final ContextAuthority contextAuthority;
    private final ContextManager contextManager;

    public ContextService(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("Cannot create a context service with a null manager");
        }
        this.contextManager = contextManager;
        this.contextAuthority = new ContextAuthority(contextManager, this);
    }

    public final IContextActivation activateContext(String contextId) {
        ContextActivation activation = new ContextActivation(contextId, null, 0, this);
        this.contextAuthority.activateContext(activation);
        return activation;
    }

    public final IContextActivation activateContext(String contextId, Expression expression, int sourcePriority) {
        if (expression == null) {
            throw new NullPointerException("The expression cannot be null");
        }
        ContextActivation activation = new ContextActivation(contextId, expression, sourcePriority, this);
        this.contextAuthority.activateContext(activation);
        return activation;
    }

    public final void addSourceProvider(ISourceProvider provider) {
        this.contextAuthority.addSourceProvider(provider);
    }

    public final void deactivateContext(IContextActivation activation) {
        if (activation.getContextService() == this) {
            this.contextAuthority.deactivateContext(activation);
        }
    }

    public final void deactivateContexts(Collection activations) {
        Iterator activationItr = activations.iterator();
        while (activationItr.hasNext()) {
            IContextActivation activation = (IContextActivation)activationItr.next();
            this.deactivateContext(activation);
        }
    }

    public final Context getContext(String contextId) {
        return this.contextManager.getContext(contextId);
    }

    public final Collection getDefinedContextIds() {
        return this.contextManager.getDefinedContextIds();
    }

    public final int getShellType(Shell shell) {
        return this.contextAuthority.getShellType(shell);
    }

    public final void readRegistry() {
        ContextPersistence.read(this.contextManager);
    }

    public final boolean registerShell(Shell shell, int type) {
        return this.contextAuthority.registerShell(shell, type);
    }

    public final void removeSourceProvider(ISourceProvider provider) {
        this.contextAuthority.removeSourceProvider(provider);
    }

    public final boolean unregisterShell(Shell shell) {
        return this.contextAuthority.unregisterShell(shell);
    }

    public final void updateShellKludge() {
        this.contextAuthority.updateShellKludge();
    }

    public final void updateShellKludge(Shell shell) {
        Shell currentActiveShell = this.contextAuthority.getActiveShell();
        if (currentActiveShell != shell) {
            this.contextAuthority.sourceChanged(1024, "activeShell", shell);
        }
    }
}

