/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.dialogs.FilteredPreferenceDialog;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.util.PrefUtil;

public class WorkbenchPreferenceDialog
extends FilteredPreferenceDialog {
    private static WorkbenchPreferenceDialog instance = null;

    public static final WorkbenchPreferenceDialog createDialogOn(Shell shell, String preferencePageId) {
        WorkbenchPreferenceDialog dialog;
        if (instance == null) {
            Shell parentShell = shell;
            if (parentShell == null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                parentShell = workbenchWindow != null ? workbenchWindow.getShell() : null;
            }
            PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
            dialog = new WorkbenchPreferenceDialog(parentShell, preferenceManager);
            if (preferencePageId != null) {
                dialog.setSelectedNode(preferencePageId);
            }
            dialog.create();
            PlatformUI.getWorkbench().getHelpSystem().setHelp(dialog.getShell(), "org.eclipse.ui.preference_dialog_context");
        } else {
            dialog = instance;
            if (preferencePageId != null) {
                dialog.setCurrentPageId(preferencePageId);
            }
        }
        return dialog;
    }

    public WorkbenchPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
        Assert.isTrue(instance == null, "There cannot be two preference dialogs at once in the workbench.");
        instance = this;
    }

    public boolean close() {
        instance = null;
        return super.close();
    }

    protected IPreferenceNode findNodeMatching(String nodeId) {
        IPreferenceNode node = super.findNodeMatching(nodeId);
        if (WorkbenchActivityHelper.filterItem(node)) {
            return null;
        }
        return node;
    }

    protected void okPressed() {
        PrefUtil.savePrefs();
        super.okPressed();
    }
}

