/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class HandlerActivation
implements IHandlerActivation {
    private final String commandId;
    private EvaluationResult evaluationResult = null;
    private final Expression expression;
    private final IHandler handler;
    private final IHandlerService handlerService;
    private final int sourcePriority;

    public HandlerActivation(String commandId, IHandler handler, Expression expression, int sourcePriority, IHandlerService handlerService) {
        if (commandId == null) {
            throw new NullPointerException("The command identifier for a handler activation cannot be null");
        }
        if (handlerService == null) {
            throw new NullPointerException("The handler service for an activation cannot be null");
        }
        this.commandId = commandId;
        this.handler = handler;
        this.expression = expression;
        this.sourcePriority = sourcePriority;
        this.handlerService = handlerService;
    }

    public final void clearActive() {
        this.evaluationResult = null;
    }

    public final String getCommandId() {
        return this.commandId;
    }

    public final IHandler getHandler() {
        return this.handler;
    }

    public final IHandlerService getHandlerService() {
        return this.handlerService;
    }

    public final int getSourcePriority() {
        return this.sourcePriority;
    }

    public final boolean isActive(IEvaluationContext context) {
        if (this.expression == null) {
            return true;
        }
        if (this.evaluationResult == null) {
            try {
                this.evaluationResult = this.expression.evaluate(context);
            }
            catch (CoreException e) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, e.getMessage(), e);
                WorkbenchPlugin.log("Could not evaluate an expression", status);
                return false;
            }
        }
        return this.evaluationResult == EvaluationResult.TRUE;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("HandlerActivation(commandId=");
        buffer.append(this.commandId);
        buffer.append(",handler=");
        buffer.append(this.handler);
        buffer.append(",expression=");
        buffer.append(this.expression);
        buffer.append(",sourcePriority=");
        buffer.append(this.sourcePriority);
        buffer.append(",evaluationResult=");
        buffer.append(this.evaluationResult);
        buffer.append(')');
        return buffer.toString();
    }
}

