/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;

public final class BindingPersistence {
    private static final String ATTRIBUTE_COMMAND = "command";
    private static final String ATTRIBUTE_COMMAND_ID = "commandId";
    private static final String ATTRIBUTE_CONFIGURATION = "configuration";
    private static final String ATTRIBUTE_CONTEXT_ID = "contextId";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_KEY_CONFIGURATION_ID = "keyConfigurationId";
    private static final String ATTRIBUTE_KEY_SEQUENCE = "keySequence";
    private static final String ATTRIBUTE_LOCALE = "locale";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PARENT = "parent";
    private static final String ATTRIBUTE_PARENT_ID = "parentId";
    private static final String ATTRIBUTE_PLATFORM = "platform";
    private static final String ATTRIBUTE_SCHEME_ID = "schemeId";
    private static final String ATTRIBUTE_SCOPE = "scope";
    private static final String ATTRIBUTE_SEQUENCE = "sequence";
    private static final String ATTRIBUTE_STRING = "string";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final String ELEMENT_ACCELERATOR_CONFIGURATION = "acceleratorConfiguration";
    private static final String ELEMENT_ACTIVE_KEY_CONFIGURATION = "activeKeyConfiguration";
    private static final String ELEMENT_ACTIVE_SCHEME = "activeKeyConfiguration";
    private static final String ELEMENT_BINDING = "keyBinding";
    private static final String ELEMENT_KEY = "key";
    private static final String ELEMENT_KEY_BINDING = "keyBinding";
    private static final String ELEMENT_KEY_CONFIGURATION = "keyConfiguration";
    private static final String ELEMENT_PARAMETER = "parameter";
    private static final String ELEMENT_SCHEME = "scheme";
    private static final String EXTENSION_ACCELERATOR_CONFIGURATIONS = "org.eclipse.ui.acceleratorConfigurations";
    private static final String EXTENSION_BINDINGS = "org.eclipse.ui.bindings";
    private static final String EXTENSION_COMMANDS = "org.eclipse.ui.commands";
    private static final int INDEX_ACTIVE_SCHEME = 0;
    private static final int INDEX_BINDING_DEFINITIONS = 1;
    private static final int INDEX_SCHEME_DEFINITIONS = 2;
    private static final String LEGACY_DEFAULT_SCOPE = "org.eclipse.ui.globalScope";
    private static boolean listenersAttached = false;
    private static final Map r2_1KeysByName = new HashMap();

    static {
        IKeyLookup lookup = KeyLookupFactory.getDefault();
        r2_1KeysByName.put("BACKSPACE", lookup.formalKeyLookupInteger("BACKSPACE"));
        r2_1KeysByName.put("TAB", lookup.formalKeyLookupInteger("TAB"));
        r2_1KeysByName.put("RETURN", lookup.formalKeyLookupInteger("RETURN"));
        r2_1KeysByName.put("ENTER", lookup.formalKeyLookupInteger("ENTER"));
        r2_1KeysByName.put("ESCAPE", lookup.formalKeyLookupInteger("ESCAPE"));
        r2_1KeysByName.put("ESC", lookup.formalKeyLookupInteger("ESC"));
        r2_1KeysByName.put("DELETE", lookup.formalKeyLookupInteger("DELETE"));
        r2_1KeysByName.put("SPACE", lookup.formalKeyLookupInteger("SPACE"));
        r2_1KeysByName.put("ARROW_UP", lookup.formalKeyLookupInteger("ARROW_UP"));
        r2_1KeysByName.put("ARROW_DOWN", lookup.formalKeyLookupInteger("ARROW_DOWN"));
        r2_1KeysByName.put("ARROW_LEFT", lookup.formalKeyLookupInteger("ARROW_LEFT"));
        r2_1KeysByName.put("ARROW_RIGHT", lookup.formalKeyLookupInteger("ARROW_RIGHT"));
        r2_1KeysByName.put("PAGE_UP", lookup.formalKeyLookupInteger("PAGE_UP"));
        r2_1KeysByName.put("PAGE_DOWN", lookup.formalKeyLookupInteger("PAGE_DOWN"));
        r2_1KeysByName.put("HOME", lookup.formalKeyLookupInteger("HOME"));
        r2_1KeysByName.put("END", lookup.formalKeyLookupInteger("END"));
        r2_1KeysByName.put("INSERT", lookup.formalKeyLookupInteger("INSERT"));
        r2_1KeysByName.put("F1", lookup.formalKeyLookupInteger("F1"));
        r2_1KeysByName.put("F2", lookup.formalKeyLookupInteger("F2"));
        r2_1KeysByName.put("F3", lookup.formalKeyLookupInteger("F3"));
        r2_1KeysByName.put("F4", lookup.formalKeyLookupInteger("F4"));
        r2_1KeysByName.put("F5", lookup.formalKeyLookupInteger("F5"));
        r2_1KeysByName.put("F6", lookup.formalKeyLookupInteger("F6"));
        r2_1KeysByName.put("F7", lookup.formalKeyLookupInteger("F7"));
        r2_1KeysByName.put("F8", lookup.formalKeyLookupInteger("F8"));
        r2_1KeysByName.put("F9", lookup.formalKeyLookupInteger("F9"));
        r2_1KeysByName.put("F10", lookup.formalKeyLookupInteger("F10"));
        r2_1KeysByName.put("F11", lookup.formalKeyLookupInteger("F11"));
        r2_1KeysByName.put("F12", lookup.formalKeyLookupInteger("F12"));
    }

    private static final void addElementToIndexedArray(IConfigurationElement elementToAdd, IConfigurationElement[][] indexedArray, int index, int currentCount) {
        IConfigurationElement[] elements;
        if (currentCount == 0) {
            elements = new IConfigurationElement[1];
            indexedArray[index] = elements;
        } else if (currentCount >= indexedArray[index].length) {
            IConfigurationElement[] copy = new IConfigurationElement[indexedArray[index].length * 2];
            System.arraycopy(indexedArray[index], 0, copy, 0, currentCount);
            elements = copy;
            indexedArray[index] = elements;
        } else {
            elements = indexedArray[index];
        }
        elements[currentCount] = elementToAdd;
    }

    private static final KeySequence convert2_1Sequence(int[] r21KeySequence) {
        int r21KeySequenceLength = r21KeySequence.length;
        KeyStroke[] keyStrokes = new KeyStroke[r21KeySequenceLength];
        int i = 0;
        while (i < r21KeySequenceLength) {
            keyStrokes[i] = BindingPersistence.convert2_1Stroke(r21KeySequence[i]);
            ++i;
        }
        return KeySequence.getInstance(keyStrokes);
    }

    private static final KeyStroke convert2_1Stroke(int r21Stroke) {
        return SWTKeySupport.convertAcceleratorToKeyStroke(r21Stroke);
    }

    static final String getDefaultSchemeId() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getDefaultString("KEY_CONFIGURATION_ID");
    }

    private static final int[] parse2_1Sequence(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int length = stringTokenizer.countTokens();
        int[] strokes = new int[length];
        int i = 0;
        while (i < length) {
            strokes[i] = BindingPersistence.parse2_1Stroke(stringTokenizer.nextToken());
            ++i;
        }
        return strokes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int parse2_1Stroke(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+", true);
        int size = stringTokenizer.countTokens();
        String[] tokens = new String[size];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            tokens[i] = stringTokenizer.nextToken();
            ++i;
        }
        int value = 0;
        if (size % 2 != 1) return value;
        String token = tokens[size - 1];
        Integer integer = (Integer)r2_1KeysByName.get(token.toUpperCase());
        if (integer != null) {
            value = integer;
        } else if (token.length() == 1) {
            value = token.toUpperCase().charAt(0);
        }
        if (value == 0) return value;
        int i2 = 0;
        while (i2 < size - 1) {
            token = tokens[i2];
            if (i2 % 2 == 0) {
                if (token.equalsIgnoreCase("CTRL")) {
                    if ((value & 0x40000) != 0) {
                        return 0;
                    }
                    value |= 0x40000;
                } else if (token.equalsIgnoreCase("ALT")) {
                    if ((value & 0x10000) != 0) {
                        return 0;
                    }
                    value |= 0x10000;
                } else if (token.equalsIgnoreCase("SHIFT")) {
                    if ((value & 0x20000) != 0) {
                        return 0;
                    }
                    value |= 0x20000;
                } else {
                    if (!token.equalsIgnoreCase("COMMAND")) return 0;
                    if ((value & 0x400000) != 0) {
                        return 0;
                    }
                    value |= 0x400000;
                }
            } else if (!"+".equals(token)) {
                return 0;
            }
            ++i2;
        }
        return value;
    }

    static final void read(final BindingManager bindingManager, final ICommandService commandService) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int activeSchemeElementCount = 0;
        int bindingDefinitionCount = 0;
        int schemeDefinitionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[3][];
        IConfigurationElement[] bindingsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_BINDINGS);
        int i = 0;
        while (i < bindingsExtensionPoint.length) {
            IConfigurationElement configurationElement = bindingsExtensionPoint[i];
            String name = configurationElement.getName();
            if (ELEMENT_KEY.equals(name)) {
                BindingPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, bindingDefinitionCount++);
            } else if (ELEMENT_SCHEME.equals(name)) {
                BindingPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, schemeDefinitionCount++);
            }
            ++i;
        }
        IConfigurationElement[] commandsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_COMMANDS);
        int i2 = 0;
        while (i2 < commandsExtensionPoint.length) {
            IConfigurationElement configurationElement = commandsExtensionPoint[i2];
            String name = configurationElement.getName();
            if ("keyBinding".equals(name)) {
                BindingPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 1, bindingDefinitionCount++);
            } else if (ELEMENT_KEY_CONFIGURATION.equals(name)) {
                BindingPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, schemeDefinitionCount++);
            } else if ("activeKeyConfiguration".equals(name)) {
                BindingPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 0, activeSchemeElementCount++);
            }
            ++i2;
        }
        IConfigurationElement[] acceleratorConfigurationsExtensionPoint = registry.getConfigurationElementsFor(EXTENSION_ACCELERATOR_CONFIGURATIONS);
        int i3 = 0;
        while (i3 < acceleratorConfigurationsExtensionPoint.length) {
            IConfigurationElement configurationElement = acceleratorConfigurationsExtensionPoint[i3];
            String name = configurationElement.getName();
            if (ELEMENT_ACCELERATOR_CONFIGURATION.equals(name)) {
                BindingPersistence.addElementToIndexedArray(configurationElement, indexedConfigurationElements, 2, schemeDefinitionCount++);
            }
            ++i3;
        }
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        String preferenceString = store.getString(EXTENSION_COMMANDS);
        XMLMemento preferenceMemento = null;
        if (preferenceString != null && preferenceString.length() > 0) {
            StringReader reader = new StringReader(preferenceString);
            try {
                preferenceMemento = XMLMemento.createReadRoot(reader);
            }
            catch (WorkbenchException workbenchException) {}
        }
        BindingPersistence.readSchemes(indexedConfigurationElements[2], schemeDefinitionCount, bindingManager);
        BindingPersistence.readActiveScheme(indexedConfigurationElements[0], activeSchemeElementCount, preferenceMemento, bindingManager);
        BindingPersistence.readBindingsFromRegistry(indexedConfigurationElements[1], bindingDefinitionCount, bindingManager, commandService);
        BindingPersistence.readBindingsFromPreferences(preferenceMemento, bindingManager, commandService);
        if (!listenersAttached) {
            store.addPropertyChangeListener(new IPropertyChangeListener(){

                public final void propertyChange(PropertyChangeEvent event) {
                    if (BindingPersistence.EXTENSION_COMMANDS.equals(event.getProperty())) {
                        BindingPersistence.read(bindingManager, commandService);
                    }
                }
            });
            registry.addRegistryChangeListener(new IRegistryChangeListener(){

                public final void registryChanged(IRegistryChangeEvent event) {
                    IExtensionDelta[] actionDefinitionDeltas;
                    IExtensionDelta[] contextDeltas;
                    IExtensionDelta[] acceleratorScopeDeltas;
                    IExtensionDelta[] commandDeltas;
                    IExtensionDelta[] bindingDeltas;
                    IExtensionDelta[] acceleratorConfigurationDeltas = event.getExtensionDeltas("org.eclipse.ui", "acceleratorConfigurations");
                    if (acceleratorConfigurationDeltas.length == 0 && (bindingDeltas = event.getExtensionDeltas("org.eclipse.ui", "bindings")).length == 0 && (commandDeltas = event.getExtensionDeltas("org.eclipse.ui", "commands")).length == 0 && (acceleratorScopeDeltas = event.getExtensionDeltas("org.eclipse.ui", "acceleratorScopes")).length == 0 && (contextDeltas = event.getExtensionDeltas("org.eclipse.ui", "contexts")).length == 0 && (actionDefinitionDeltas = event.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length == 0) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(this, bindingManager, commandService){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ BindingManager val$bindingManager;
                        private final /* synthetic */ ICommandService val$commandService;
                        {
                            this.this$1 = var1_1;
                            this.val$bindingManager = bindingManager;
                            this.val$commandService = iCommandService;
                        }

                        public void run() {
                            BindingPersistence.read(this.val$bindingManager, this.val$commandService);
                        }
                    });
                }
            }, "org.eclipse.ui");
            listenersAttached = true;
        }
    }

    private static final void readActiveScheme(IConfigurationElement[] configurationElements, int configurationElementCount, IMemento preferences, BindingManager bindingManager) {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String defaultActiveSchemeId = store.getDefaultString("KEY_CONFIGURATION_ID");
        String preferenceActiveSchemeId = store.getString("KEY_CONFIGURATION_ID");
        if (preferenceActiveSchemeId != null && !preferenceActiveSchemeId.equals(defaultActiveSchemeId)) {
            try {
                bindingManager.setActiveScheme(bindingManager.getScheme(preferenceActiveSchemeId));
                return;
            }
            catch (NotDefinedException notDefinedException) {}
        }
        if (preferences != null) {
            IMemento[] preferenceMementos = preferences.getChildren("activeKeyConfiguration");
            int preferenceMementoCount = preferenceMementos.length;
            int i = preferenceMementoCount - 1;
            while (i >= 0) {
                IMemento memento = preferenceMementos[i];
                String id = memento.getString(ATTRIBUTE_KEY_CONFIGURATION_ID);
                if (id != null) {
                    try {
                        bindingManager.setActiveScheme(bindingManager.getScheme(id));
                        return;
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                --i;
            }
        }
        if (defaultActiveSchemeId != null && !defaultActiveSchemeId.equals("org.eclipse.ui.defaultAcceleratorConfiguration")) {
            try {
                bindingManager.setActiveScheme(bindingManager.getScheme(defaultActiveSchemeId));
                return;
            }
            catch (NotDefinedException notDefinedException) {}
        }
        int i = configurationElementCount - 1;
        while (i >= 0) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = configurationElement.getAttribute(ATTRIBUTE_KEY_CONFIGURATION_ID);
            if (id != null) {
                try {
                    bindingManager.setActiveScheme(bindingManager.getScheme(id));
                    return;
                }
                catch (NotDefinedException notDefinedException) {}
            }
            if ((id = configurationElement.getAttribute(ATTRIBUTE_VALUE)) != null) {
                try {
                    bindingManager.setActiveScheme(bindingManager.getScheme(id));
                    return;
                }
                catch (NotDefinedException notDefinedException) {}
            }
            --i;
        }
        try {
            bindingManager.setActiveScheme(bindingManager.getScheme("org.eclipse.ui.defaultAcceleratorConfiguration"));
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("The default default active scheme id is not defined.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void readBindingsFromPreferences(IMemento preferences, BindingManager bindingManager, ICommandService commandService) {
        block15: {
            warningsToLog = new ArrayList<Status>(1);
            if (preferences == null) break block15;
            preferenceMementos = preferences.getChildren("keyBinding");
            preferenceMementoCount = preferenceMementos.length;
            i = preferenceMementoCount - 1;
            while (i >= 0) {
                block14: {
                    block17: {
                        block18: {
                            block16: {
                                memento = preferenceMementos[i];
                                commandId = memento.getString("commandId");
                                if (commandId == null || commandId.length() == 0) {
                                    commandId = memento.getString("command");
                                }
                                if (commandId != null && commandId.length() == 0) {
                                    commandId = null;
                                }
                                command = commandId != null ? commandService.getCommand(commandId) : null;
                                schemeId = memento.getString("keyConfigurationId");
                                if (schemeId != null && schemeId.length() != 0 || (schemeId = memento.getString("configuration")) != null && schemeId.length() != 0) break block16;
                                message = "Key bindings need a scheme or key configuration: commandId='" + commandId + "'.";
                                status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                                warningsToLog.add(status);
                                break block14;
                            }
                            contextId = memento.getString("contextId");
                            if ("org.eclipse.ui.globalScope".equals(contextId)) {
                                contextId = null;
                            } else if ((contextId == null || contextId.length() == 0) && "org.eclipse.ui.globalScope".equals(contextId = memento.getString("scope"))) {
                                contextId = null;
                            }
                            if (contextId == null || contextId.length() == 0) {
                                contextId = "org.eclipse.ui.contexts.window";
                            }
                            keySequenceText = memento.getString("keySequence");
                            keySequence = null;
                            if (keySequenceText != null && keySequenceText.length() != 0) break block17;
                            keySequenceText = memento.getString("string");
                            if (keySequenceText != null && keySequenceText.length() != 0) break block18;
                            message = "Key bindings need a key sequence or string: commandId='" + commandId + "'.";
                            status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                            warningsToLog.add(status);
                            break block14;
                        }
                        keySequence = BindingPersistence.convert2_1Sequence(BindingPersistence.parse2_1Sequence(keySequenceText));
                        ** GOTO lbl-1000
                    }
                    try {
                        keySequence = KeySequence.getInstance(keySequenceText);
                    }
                    catch (ParseException v0) {
                        message = "Could not parse: sequence='" + keySequenceText + "': commandId='" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                        break block14;
                    }
                    if (keySequence.isEmpty() || !keySequence.isComplete()) {
                        message = "Key bindings cannot use an empty or incomplete key sequence: sequence='" + keySequence + "': commandId='" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                    } else lbl-1000:
                    // 2 sources

                    {
                        locale = memento.getString("locale");
                        if (locale != null && locale.length() == 0) {
                            locale = null;
                        }
                        if ((platform = memento.getString("platform")) != null && platform.length() == 0) {
                            platform = null;
                        }
                        parameterizedCommand = command == null ? null : BindingPersistence.readParameters(memento, warningsToLog, command);
                        binding = new KeyBinding(keySequence, parameterizedCommand, schemeId, contextId, locale, platform, null, 1);
                        bindingManager.addBinding(binding);
                    }
                }
                --i;
            }
        }
        if (!warningsToLog.isEmpty()) {
            status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the key bindings from the preference store", null);
            WorkbenchPlugin.log(status);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void readBindingsFromRegistry(IConfigurationElement[] configurationElements, int configurationElementCount, BindingManager bindingManager, ICommandService commandService) {
        bindings = new ArrayList<KeyBinding>(configurationElementCount);
        warningsToLog = new ArrayList<Status>(1);
        i = 0;
        while (i < configurationElementCount) {
            block17: {
                block21: {
                    block22: {
                        block20: {
                            block19: {
                                block18: {
                                    configurationElement = configurationElements[i];
                                    commandId = configurationElement.getAttribute("commandId");
                                    if (commandId == null || commandId.length() == 0) {
                                        commandId = configurationElement.getAttribute("command");
                                    }
                                    if (commandId != null && commandId.length() == 0) {
                                        commandId = null;
                                    }
                                    if (commandId == null) break block18;
                                    command = commandService.getCommand(commandId);
                                    if (command.isDefined()) break block19;
                                    message = "Cannot bind to an undefined command: plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                                    status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                                    warningsToLog.add(status);
                                    break block17;
                                }
                                command = null;
                            }
                            if ((schemeId = configurationElement.getAttribute("schemeId")) != null && schemeId.length() != 0 || (schemeId = configurationElement.getAttribute("keyConfigurationId")) != null && schemeId.length() != 0 || (schemeId = configurationElement.getAttribute("configuration")) != null && schemeId.length() != 0) break block20;
                            message = "Key bindings need a scheme: plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                            status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                            warningsToLog.add(status);
                            break block17;
                        }
                        contextId = configurationElement.getAttribute("contextId");
                        if ("org.eclipse.ui.globalScope".equals(contextId)) {
                            contextId = null;
                        } else if ((contextId == null || contextId.length() == 0) && "org.eclipse.ui.globalScope".equals(contextId = configurationElement.getAttribute("scope"))) {
                            contextId = null;
                        }
                        if (contextId == null || contextId.length() == 0) {
                            contextId = "org.eclipse.ui.contexts.window";
                        }
                        keySequence = null;
                        keySequenceText = configurationElement.getAttribute("sequence");
                        if (keySequenceText == null || keySequenceText.length() == 0) {
                            keySequenceText = configurationElement.getAttribute("keySequence");
                        }
                        if (keySequenceText != null && keySequenceText.length() != 0) break block21;
                        keySequenceText = configurationElement.getAttribute("string");
                        if (keySequenceText != null && keySequenceText.length() != 0) break block22;
                        message = "Defining a key binding with no key sequence has no effect: plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                        break block17;
                    }
                    try {
                        keySequence = BindingPersistence.convert2_1Sequence(BindingPersistence.parse2_1Sequence(keySequenceText));
                        ** GOTO lbl-1000
                    }
                    catch (IllegalArgumentException v0) {
                        message = "Could not parse key sequence '" + keySequenceText + "': plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                        status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                        break block17;
                    }
                }
                try {
                    keySequence = KeySequence.getInstance(keySequenceText);
                }
                catch (ParseException v1) {
                    message = "Could not parse key sequence '" + keySequenceText + "': plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                    status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                    break block17;
                }
                if (keySequence.isEmpty() || !keySequence.isComplete()) {
                    message = "Key bindings should not have an empty or incomplete key sequence: sequence='" + keySequence + "': plug-in='" + configurationElement.getNamespace() + "', commandId='" + commandId + "'.";
                    status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                } else lbl-1000:
                // 2 sources

                {
                    locale = configurationElement.getAttribute("locale");
                    if (locale != null && locale.length() == 0) {
                        locale = null;
                    }
                    if ((platform = configurationElement.getAttribute("platform")) != null && platform.length() == 0) {
                        platform = null;
                    }
                    parameterizedCommand = command == null ? null : BindingPersistence.readParameters(configurationElement, warningsToLog, command);
                    binding = new KeyBinding(keySequence, parameterizedCommand, schemeId, contextId, locale, platform, null, 0);
                    bindings.add(binding);
                }
            }
            ++i;
        }
        bindingArray = bindings.toArray(new Binding[bindings.size()]);
        bindingManager.setBindings(bindingArray);
        if (!warningsToLog.isEmpty()) {
            status = new MultiStatus(WorkbenchPlugin.PI_WORKBENCH, 0, warningsToLog.toArray(new IStatus[warningsToLog.size()]), "Warnings while parsing the key bindings from the 'org.eclipse.ui.commands' extension point", null);
            WorkbenchPlugin.log(status);
        }
    }

    private static final ParameterizedCommand readParameters(IConfigurationElement configurationElement, List warningsToLog, Command command) {
        IConfigurationElement[] parameterElements = configurationElement.getChildren(ELEMENT_PARAMETER);
        if (parameterElements == null || parameterElements.length == 0) {
            return new ParameterizedCommand(command, null);
        }
        ArrayList<Parameterization> parameters = new ArrayList<Parameterization>();
        int i = 0;
        while (i < parameterElements.length) {
            IConfigurationElement parameterElement = parameterElements[i];
            String id = parameterElement.getAttribute(ATTRIBUTE_ID);
            if (id == null || id.length() == 0) {
                String message = "Parameters need a name: plug-in='" + configurationElement.getNamespace() + "'.";
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                warningsToLog.add(status);
            } else {
                IParameter parameter;
                block13: {
                    parameter = null;
                    try {
                        IParameter[] commandParameters = command.getParameters();
                        if (parameters == null) break block13;
                        int j = 0;
                        while (j < commandParameters.length) {
                            IParameter currentParameter = commandParameters[j];
                            if (Util.equals(currentParameter.getId(), id)) {
                                parameter = currentParameter;
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                if (parameter == null) {
                    String message = "Could not find a matching parameter: plug-in='" + configurationElement.getNamespace() + "', parameterId='" + id + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                } else {
                    String value = parameterElement.getAttribute(ATTRIBUTE_VALUE);
                    if (value == null || value.length() == 0) {
                        String message = "Parameters need a value: plug-in='" + configurationElement.getNamespace() + "', parameterId='" + id + "'.";
                        Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                    } else {
                        parameters.add(new Parameterization(parameter, value));
                    }
                }
            }
            ++i;
        }
        if (parameters.isEmpty()) {
            return new ParameterizedCommand(command, null);
        }
        return new ParameterizedCommand(command, parameters.toArray(new Parameterization[parameters.size()]));
    }

    private static final ParameterizedCommand readParameters(IMemento memento, List warningsToLog, Command command) {
        IMemento[] parameterElements = memento.getChildren(ELEMENT_PARAMETER);
        if (parameterElements == null || parameterElements.length == 0) {
            return new ParameterizedCommand(command, null);
        }
        ArrayList<Parameterization> parameters = new ArrayList<Parameterization>();
        int i = 0;
        while (i < parameterElements.length) {
            IMemento parameterElement = parameterElements[i];
            String id = parameterElement.getString(ATTRIBUTE_ID);
            if (id == null || id.length() == 0) {
                Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, "Parameters need a name: preferences.", null);
                warningsToLog.add(status);
            } else {
                IParameter parameter;
                block13: {
                    parameter = null;
                    try {
                        IParameter[] commandParameters = command.getParameters();
                        if (parameters == null) break block13;
                        int j = 0;
                        while (j < commandParameters.length) {
                            IParameter currentParameter = commandParameters[j];
                            if (Util.equals(currentParameter.getId(), id)) {
                                parameter = currentParameter;
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                if (parameter == null) {
                    String message = "Could not find a matching parameter: preferences, parameterId='" + id + "'.";
                    Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                    warningsToLog.add(status);
                } else {
                    String value = parameterElement.getString(ATTRIBUTE_VALUE);
                    if (value == null || value.length() == 0) {
                        String message = "Parameters need a value: preferences, parameterId='" + id + "'.";
                        Status status = new Status(2, WorkbenchPlugin.PI_WORKBENCH, 0, message, null);
                        warningsToLog.add(status);
                    } else {
                        parameters.add(new Parameterization(parameter, value));
                    }
                }
            }
            ++i;
        }
        if (parameters.isEmpty()) {
            return new ParameterizedCommand(command, null);
        }
        return new ParameterizedCommand(command, parameters.toArray(new Parameterization[parameters.size()]));
    }

    private static final void readSchemes(IConfigurationElement[] configurationElements, int configurationElementCount, BindingManager bindingManager) {
        int i;
        Scheme[] handleObjects = bindingManager.getDefinedSchemes();
        if (handleObjects != null) {
            i = 0;
            while (i < handleObjects.length) {
                handleObjects[i].undefine();
                ++i;
            }
        }
        i = 0;
        while (i < configurationElementCount) {
            IConfigurationElement configurationElement = configurationElements[i];
            String id = configurationElement.getAttribute(ATTRIBUTE_ID);
            if (id != null && id.length() != 0) {
                String parentId;
                String description;
                String name = configurationElement.getAttribute(ATTRIBUTE_NAME);
                if (name != null && name.length() == 0) {
                    name = null;
                }
                if ((description = configurationElement.getAttribute(ATTRIBUTE_DESCRIPTION)) != null && description.length() == 0) {
                    description = null;
                }
                if ((parentId = configurationElement.getAttribute(ATTRIBUTE_PARENT_ID)) != null && parentId.length() == 0 && (parentId = configurationElement.getAttribute(ATTRIBUTE_PARENT)) != null && parentId.length() == 0) {
                    parentId = null;
                }
                Scheme scheme = bindingManager.getScheme(id);
                scheme.define(name, description, parentId);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final void write(Scheme activeScheme, Binding[] bindings) throws IOException {
        Object var5_7;
        if (DEBUG) {
            System.out.println("BINDINGS >> Persisting active scheme '" + activeScheme.getId() + "'");
            System.out.println("BINDINGS >> Persisting bindings");
        }
        BindingPersistence.writeActiveScheme(activeScheme);
        XMLMemento xmlMemento = XMLMemento.createWriteRoot(EXTENSION_COMMANDS);
        if (activeScheme != null) {
            BindingPersistence.writeActiveScheme(xmlMemento, activeScheme);
        }
        if (bindings != null) {
            int bindingsLength = bindings.length;
            int i = 0;
            while (i < bindingsLength) {
                Binding binding = bindings[i];
                if (binding.getType() == 1) {
                    BindingPersistence.writeBinding(xmlMemento, binding);
                }
                ++i;
            }
        }
        IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save(writer);
            preferenceStore.setValue(EXTENSION_COMMANDS, ((Object)writer).toString());
        }
        catch (Throwable throwable) {
            var5_7 = null;
            ((Writer)writer).close();
            throw throwable;
        }
        {
            var5_7 = null;
        }
        ((Writer)writer).close();
    }

    private static final void writeActiveScheme(IMemento memento, Scheme scheme) {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String schemeId = scheme.getId();
        String defaultSchemeId = store.getDefaultString("KEY_CONFIGURATION_ID");
        if (defaultSchemeId == null ? schemeId != null : !defaultSchemeId.equals(schemeId)) {
            IMemento child = memento.createChild("activeKeyConfiguration");
            child.putString(ATTRIBUTE_KEY_CONFIGURATION_ID, schemeId);
        }
    }

    private static final void writeActiveScheme(Scheme scheme) {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String schemeId = scheme == null ? null : scheme.getId();
        String defaultSchemeId = store.getDefaultString("KEY_CONFIGURATION_ID");
        if (defaultSchemeId == null ? scheme != null : !defaultSchemeId.equals(schemeId)) {
            store.setValue("KEY_CONFIGURATION_ID", scheme.getId());
        } else {
            store.setToDefault("KEY_CONFIGURATION_ID");
        }
    }

    private static final void writeBinding(IMemento parent, Binding binding) {
        IMemento element = parent.createChild("keyBinding");
        element.putString(ATTRIBUTE_CONTEXT_ID, binding.getContextId());
        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
        String commandId = parameterizedCommand == null ? null : parameterizedCommand.getId();
        element.putString(ATTRIBUTE_COMMAND_ID, commandId);
        element.putString(ATTRIBUTE_KEY_CONFIGURATION_ID, binding.getSchemeId());
        element.putString(ATTRIBUTE_KEY_SEQUENCE, binding.getTriggerSequence().toString());
        element.putString(ATTRIBUTE_LOCALE, binding.getLocale());
        element.putString(ATTRIBUTE_PLATFORM, binding.getPlatform());
        if (parameterizedCommand != null) {
            Map parameterizations = parameterizedCommand.getParameterMap();
            Iterator parameterizationItr = parameterizations.entrySet().iterator();
            while (parameterizationItr.hasNext()) {
                Map.Entry entry = parameterizationItr.next();
                String id = (String)entry.getKey();
                String value = (String)entry.getValue();
                IMemento parameterElement = element.createChild(ELEMENT_PARAMETER);
                parameterElement.putString(ATTRIBUTE_ID, id);
                parameterElement.putString(ATTRIBUTE_VALUE, value);
            }
        }
    }

    private BindingPersistence() {
    }
}

