/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;

public class AdvancedValidationUserApprover
implements IOperationApprover {
    private IUndoContext context;
    static /* synthetic */ Class class$0;

    public AdvancedValidationUserApprover(IUndoContext context) {
        this.context = context;
    }

    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        return this.proceedWithOperation(operation, history, uiInfo, false);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo) {
        return this.proceedWithOperation(operation, history, uiInfo, true);
    }

    private IStatus proceedWithOperation(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo, boolean undoing) {
        if (!operation.hasContext(this.context)) {
            return Status.OK_STATUS;
        }
        if (!(operation instanceof IAdvancedUndoableOperation)) {
            return Status.OK_STATUS;
        }
        IStatus status = this.computeOperationStatus(operation, history, uiInfo, undoing);
        if (!status.isOK()) {
            status = this.reportAndInterpretStatus(status, uiInfo, operation, undoing);
        }
        if (!status.isOK()) {
            history.operationChanged(operation);
        }
        return status;
    }

    private IStatus computeOperationStatus(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo, boolean undoing) {
        try {
            StatusReportingRunnable runnable = new StatusReportingRunnable(operation, history, uiInfo, undoing);
            TimeTriggeredProgressMonitorDialog progressDialog = new TimeTriggeredProgressMonitorDialog(this.getShell(uiInfo), PlatformUI.getWorkbench().getProgressService().getLongOperationTime());
            progressDialog.run(false, true, runnable);
            return runnable.getStatus();
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (InvocationTargetException e) {
            this.reportException(e, uiInfo);
            return IOperationHistory.OPERATION_INVALID_STATUS;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
    }

    private void reportException(Exception e, IAdaptable uiInfo) {
        Throwable nestedException = StatusUtil.getCause(e);
        Throwable exception = nestedException == null ? e : nestedException;
        String title = WorkbenchMessages.Error;
        String message = WorkbenchMessages.WorkbenchWindow_exceptionMessage;
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        WorkbenchPlugin.log(message, status);
        boolean createdShell = false;
        Shell shell = this.getShell(uiInfo);
        if (shell == null) {
            createdShell = true;
            shell = new Shell();
        }
        ErrorDialog.openError(shell, title, message, status);
        if (createdShell) {
            shell.dispose();
        }
    }

    private IStatus reportAndInterpretStatus(IStatus status, IAdaptable uiInfo, IUndoableOperation operation, boolean undoing) {
        if (status.getSeverity() == 8) {
            return status;
        }
        boolean createdShell = false;
        IStatus reportedStatus = status;
        Shell shell = this.getShell(uiInfo);
        if (shell == null) {
            createdShell = true;
            shell = new Shell();
        }
        if (status.getSeverity() != 4) {
            boolean proceed;
            String title;
            String warning;
            if (undoing) {
                warning = WorkbenchMessages.Operations_proceedWithNonOKUndoStatus;
                title = status.getSeverity() == 1 ? WorkbenchMessages.Operations_undoInfo : WorkbenchMessages.Operations_undoWarning;
            } else {
                warning = WorkbenchMessages.Operations_proceedWithNonOKRedoStatus;
                title = status.getSeverity() == 1 ? WorkbenchMessages.Operations_redoInfo : WorkbenchMessages.Operations_redoWarning;
            }
            String message = NLS.bind(warning, new Object[]{title, status.getMessage(), operation.getLabel()});
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            MessageDialog dialog = new MessageDialog(shell, title, null, message, 4, buttons, 0);
            boolean bl = proceed = dialog.open() == 0;
            if (proceed) {
                reportedStatus = Status.OK_STATUS;
            }
        } else {
            String stopped;
            String title;
            if (undoing) {
                title = WorkbenchMessages.Operations_undoProblem;
                stopped = WorkbenchMessages.Operations_stoppedOnUndoErrorStatus;
            } else {
                title = WorkbenchMessages.Operations_redoProblem;
                stopped = WorkbenchMessages.Operations_stoppedOnRedoErrorStatus;
            }
            String message = NLS.bind(stopped, status.getMessage(), operation.getLabel());
            MessageDialog dialog = new MessageDialog(shell, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
        }
        if (createdShell) {
            shell.dispose();
        }
        return reportedStatus;
    }

    Shell getShell(IAdaptable uiInfo) {
        if (uiInfo != null) {
            Shell shell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((shell = (Shell)uiInfo.getAdapter(clazz)) != null) {
                return shell;
            }
        }
        return null;
    }

    private class StatusReportingRunnable
    implements IRunnableWithProgress {
        IStatus status;
        boolean undoing;
        IUndoableOperation operation;
        IOperationHistory history;
        IAdaptable uiInfo;

        StatusReportingRunnable(IUndoableOperation operation, IOperationHistory history, IAdaptable uiInfo, boolean undoing) {
            this.operation = operation;
            this.history = history;
            this.undoing = undoing;
            this.uiInfo = uiInfo;
        }

        public void run(IProgressMonitor pm) {
            try {
                this.status = this.undoing ? ((IAdvancedUndoableOperation)this.operation).computeUndoableStatus(pm) : ((IAdvancedUndoableOperation)this.operation).computeRedoableStatus(pm);
            }
            catch (ExecutionException e) {
                AdvancedValidationUserApprover.this.reportException((Exception)((Object)e), this.uiInfo);
                this.status = IOperationHistory.OPERATION_INVALID_STATUS;
            }
        }

        IStatus getStatus() {
            return this.status;
        }
    }
}

