/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.internal.components.ComponentUtil;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.ComponentFactory;
import org.eclipse.ui.internal.components.framework.ComponentHandle;
import org.eclipse.ui.internal.components.framework.Components;
import org.eclipse.ui.internal.components.framework.Container;
import org.eclipse.ui.internal.components.framework.FactoryMap;
import org.eclipse.ui.internal.components.framework.ServiceFactory;
import org.eclipse.ui.internal.part.Part;
import org.eclipse.ui.internal.part.SiteComposite;
import org.eclipse.ui.internal.part.components.interfaces.IFocusable;
import org.eclipse.ui.internal.part.components.services.IActionBarContributor;
import org.eclipse.ui.internal.part.multiplexer.SiteServices;

public final class ComponentPart
extends Part
implements IFocusable {
    private IPersistable persistable;
    private SiteServices container;
    private Container adapters;
    private SiteComposite control;
    private ComponentHandle component;
    private IActionBarContributor contributor = null;
    private FactoryMap visibleContext;
    private DisposeListener partDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            ComponentPart.this.disposed();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ComponentPart(Composite parent, ServiceFactory overrides, ComponentFactory factory) throws ComponentException {
        Assert.isNotNull(parent);
        Assert.isNotNull(overrides);
        Assert.isNotNull(factory);
        Assert.isTrue(!parent.isDisposed());
        if (overrides == null) {
            overrides = new FactoryMap();
        }
        try {
            ServiceFactory additionalContext;
            this.control = new SiteComposite(parent);
            this.control.setLayout(new FillLayout());
            ServiceFactory outputContext = ComponentUtil.getContext("org.eclipse.ui.part");
            FactoryMap factoryMap = new FactoryMap().add(overrides);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Composite");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.container = new SiteServices(factoryMap.mapInstance(clazz, this.control));
            this.control.addDisposeListener(this.partDisposeListener);
            this.component = factory.createHandle(this.container);
            Object part = this.component.getInstance();
            this.visibleContext = new FactoryMap();
            this.visibleContext.addInstance(part);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.internal.components.framework.ServiceFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((additionalContext = (ServiceFactory)Components.getAdapter(part, clazz2)) != null) {
                this.visibleContext.add(additionalContext);
            }
            this.visibleContext.add(outputContext);
            this.adapters = new Container(new FactoryMap().add(this.visibleContext).add(this.container));
            Object[] objectArray = new Class[1];
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.ui.IPersistable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            objectArray[0] = clazz3;
            Object[] interfaces = Components.queryInterfaces(this.adapters, objectArray);
            this.persistable = (IPersistable)interfaces[0];
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("org.eclipse.ui.internal.part.components.interfaces.IFocusable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.control.setFocusable((IFocusable)Components.getAdapter(this.adapters, clazz4));
            this.control.layout(true);
        }
        catch (SWTException e) {
            this.control.dispose();
            throw new ComponentException(factory, (Throwable)e);
        }
        catch (ComponentException e) {
            this.control.dispose();
            throw e;
        }
    }

    public Control getControl() {
        return this.control;
    }

    private void disposed() {
        if (this.adapters != null) {
            this.adapters.dispose();
        }
        if (this.component != null) {
            this.component.getDisposable().dispose();
        }
        if (this.container != null) {
            this.container.dispose();
        }
    }

    public void saveState(IMemento memento) {
        this.persistable.saveState(memento);
    }

    public Object getService(Object key) throws ComponentException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.internal.part.components.interfaces.IFocusable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this;
        }
        if (this.visibleContext.hasService(key)) {
            return Components.queryInterface(this.adapters, key);
        }
        return null;
    }

    public boolean hasService(Object key) {
        return this.visibleContext.hasService(key);
    }

    public boolean setFocus() {
        return this.getControl().setFocus();
    }
}

