/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.progress.ErrorNotificationManager;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressContentProvider;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;

public class NewProgressViewer
extends TreeViewer
implements FinishedJobs.KeptJobsListener {
    static final boolean DEBUG = false;
    private static String ELLIPSIS = ProgressMessages.ProgressFloatingWindow_EllipsisValue;
    static final QualifiedName ICON_PROPERTY = IProgressConstants.ICON_PROPERTY;
    static final boolean isCarbon = "carbon".equals(SWT.getPlatform());
    static final QualifiedName KEEP_PROPERTY = IProgressConstants.KEEP_PROPERTY;
    static final QualifiedName KEEPONE_PROPERTY = IProgressConstants.KEEPONE_PROPERTY;
    private Font boldFont;
    private Image cancelJobIcon;
    private Image cancelJobDIcon;
    private Image clearJobIcon;
    private Image clearJobDIcon;
    private Color darkColor;
    private Image defaultJobIcon;
    private boolean dialogContext;
    private FinishedJobs finishedJobs;
    private Cursor handCursor;
    private JobTreeItem highlightItem;
    private Job highlightJob;
    private Color lightColor;
    private Composite list;
    private HashMap map = new HashMap();
    private Cursor normalCursor;
    private ScrolledComposite scroller;
    private Color selectedColor;
    private Color selectedTextColor;
    private Font smallerFont;
    private Color textColor;

    static String shortenText(Control control2, String textValue) {
        if (textValue != null) {
            Display display = control2.getDisplay();
            GC gc = new GC((Drawable)display);
            int maxWidth = control2.getBounds().width;
            textValue = NewProgressViewer.shortenText(gc, maxWidth, textValue);
            gc.dispose();
        }
        return textValue;
    }

    static String shortenText(GC gc, int maxWidth, String textValue) {
        int pivot;
        if (gc.textExtent((String)textValue).x < maxWidth) {
            return textValue;
        }
        int length = textValue.length();
        int ellipsisWidth = gc.textExtent((String)NewProgressViewer.ELLIPSIS).x;
        int start = pivot = length / 2;
        int end = pivot + 1;
        while (start >= 0 && end < length) {
            String s1 = textValue.substring(0, start);
            String s2 = textValue.substring(end, length);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + ellipsisWidth + l2 < maxWidth) {
                return String.valueOf(s1) + ELLIPSIS + s2;
            }
            --start;
            ++end;
        }
        return textValue;
    }

    public NewProgressViewer(Composite parent, int flags) {
        super(parent, flags);
        Tree c = this.getTree();
        if (c instanceof Tree) {
            c.dispose();
        }
        this.dialogContext = (flags & 0x800) != 0;
        this.finishedJobs = FinishedJobs.getInstance();
        this.finishedJobs.addListener(this);
        Display display = parent.getDisplay();
        this.handCursor = new Cursor(display, 21);
        this.normalCursor = new Cursor(display, 0);
        this.defaultJobIcon = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_task.gif").createImage(display);
        this.cancelJobIcon = WorkbenchImages.getWorkbenchImageDescriptor("elcl16/progress_stop.gif").createImage(display);
        this.cancelJobDIcon = WorkbenchImages.getWorkbenchImageDescriptor("dlcl16/progress_stop.gif").createImage(display);
        this.clearJobIcon = WorkbenchImages.getWorkbenchImageDescriptor("elcl16/progress_rem.gif").createImage(display);
        this.clearJobDIcon = WorkbenchImages.getWorkbenchImageDescriptor("dlcl16/progress_rem.gif").createImage(display);
        this.boldFont = this.getDefaultFont();
        FontData[] fds = this.getDefaultFontData();
        if (fds.length > 0) {
            FontData fd = fds[0];
            int h = fd.getHeight();
            this.boldFont = new Font((Device)display, fd.getName(), h, fd.getStyle() | 1);
            this.smallerFont = new Font((Device)display, fd.getName(), h, fd.getStyle());
        }
        int shift = isCarbon ? -25 : -10;
        this.lightColor = display.getSystemColor(25);
        this.darkColor = new Color(display, Math.max(0, this.lightColor.getRed() + shift), Math.max(0, this.lightColor.getGreen() + shift), Math.max(0, this.lightColor.getBlue() + shift));
        this.textColor = display.getSystemColor(24);
        this.selectedTextColor = display.getSystemColor(27);
        this.selectedColor = display.getSystemColor(26);
        this.scroller = new ScrolledComposite(parent, 0x300 | flags);
        int height = this.getDefaultFontData()[0].getHeight();
        this.scroller.getVerticalBar().setIncrement(height * 2);
        this.scroller.setExpandHorizontal(true);
        this.scroller.setExpandVertical(true);
        this.list = new Composite(this.scroller, 0);
        this.list.setFont(this.getDefaultFont());
        this.list.setBackground(this.lightColor);
        this.list.setLayout(new ListLayout());
        this.list.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                NewProgressViewer.this.select(null, event);
            }
        });
        this.scroller.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                NewProgressViewer.this.finishedJobs.removeListener(NewProgressViewer.this);
                NewProgressViewer.this.defaultJobIcon.dispose();
                NewProgressViewer.this.cancelJobIcon.dispose();
                NewProgressViewer.this.cancelJobDIcon.dispose();
                NewProgressViewer.this.clearJobIcon.dispose();
                NewProgressViewer.this.clearJobDIcon.dispose();
                NewProgressViewer.this.handCursor.dispose();
                NewProgressViewer.this.normalCursor.dispose();
                Font defaultFont = NewProgressViewer.this.getDefaultFont();
                if (NewProgressViewer.this.boldFont != defaultFont) {
                    NewProgressViewer.this.boldFont.dispose();
                }
                if (NewProgressViewer.this.smallerFont != defaultFont) {
                    NewProgressViewer.this.smallerFont.dispose();
                }
                NewProgressViewer.this.darkColor.dispose();
                NewProgressViewer.this.handleDispose(null);
            }
        });
        this.scroller.setContent(this.list);
        this.refresh(true);
    }

    public void add(Object parentElement, Object[] elements) {
        if (this.list.isDisposed()) {
            return;
        }
        JobTreeItem lastAdded = null;
        int i = 0;
        while (i < elements.length) {
            if (!this.filtered(elements[i])) {
                lastAdded = this.findJobItem(elements[i], true);
            }
            ++i;
        }
        this.relayout(true, true);
        if (lastAdded != null) {
            this.reveal(lastAdded);
        }
    }

    protected void addTreeListener(Control c, TreeListener listener) {
    }

    public void cancelSelection() {
        boolean changed = false;
        Control[] cs = this.list.getChildren();
        int i = 0;
        while (i < cs.length) {
            JobItem ji = (JobItem)cs[i];
            if (ji.selected) {
                changed |= ji.cancelOrRemove();
            }
            ++i;
        }
        this.relayout(changed, changed);
    }

    void clearAll() {
        this.finishedJobs.clearAll();
    }

    Object[] contentProviderGetChildren(Object parent) {
        IContentProvider provider = this.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)provider).getChildren(parent);
        }
        return new Object[0];
    }

    Object[] contentProviderGetRoots(Object parent) {
        IContentProvider provider = this.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)provider).getElements(parent);
        }
        return new Object[0];
    }

    protected void createChildren(Widget widget) {
        this.refresh(true);
    }

    private JobItem createItem(Object element) {
        return new JobItem(this.list, (JobTreeElement)element);
    }

    void doSelection() {
        Control[] cs = this.list.getChildren();
        int i = 0;
        while (i < cs.length) {
            JobItem ji = (JobItem)cs[i];
            if (ji.selected) {
                Control[] children = ji.getChildren();
                int j = 0;
                while (j < children.length) {
                    Hyperlink hl;
                    if (children[j] instanceof Hyperlink && (hl = (Hyperlink)children[j]).handleActivate()) {
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void doUpdateItem(Item item, Object element) {
    }

    private boolean filtered(Object element) {
        Object parent;
        if (element == null) {
            return true;
        }
        if (!this.dialogContext && ProgressViewUpdater.getSingleton().debug) {
            return false;
        }
        if (element instanceof JobInfo) {
            return this.jobFiltered((JobInfo)element);
        }
        if (element instanceof GroupInfo) {
            Object[] children = ((GroupInfo)element).getChildren();
            int i = 0;
            while (i < children.length) {
                if (this.jobFiltered((JobInfo)children[i])) {
                    return true;
                }
                ++i;
            }
        }
        if (element instanceof TaskInfo && (parent = ((TaskInfo)element).getParent()) instanceof JobInfo) {
            return this.jobFiltered((JobInfo)parent);
        }
        return false;
    }

    private JobTreeItem findJobItem(Object element, boolean create) {
        JobTreeItem ji = (JobTreeItem)this.map.get(element);
        if (ji == null && create) {
            JobTreeElement jte = (JobTreeElement)element;
            Object parent = jte.getParent();
            if (parent != null) {
                JobTreeItem parentji = this.findJobItem(parent, true);
                if (parentji instanceof JobItem && !(jte instanceof TaskInfo) && this.findJobItem(jte, false) == null) {
                    JobItem p = (JobItem)parentji;
                    p.createChild(jte);
                }
            } else {
                ji = this.createItem(jte);
            }
        }
        return ji;
    }

    public void finished(JobTreeElement jte) {
    }

    private void forcedRemove(final JobTreeElement jte) {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JobTreeItem ji = NewProgressViewer.this.findJobItem(jte, false);
                    if (ji != null && !ji.isDisposed() && ji.remove()) {
                        NewProgressViewer.this.relayout(true, true);
                    }
                }
            });
        }
    }

    private Color getActiveHyperlinkColor() {
        return JFaceColors.getActiveHyperlinkText(this.getControl().getDisplay());
    }

    protected Item[] getChildren(Widget o) {
        return new Item[0];
    }

    public Control getControl() {
        return this.scroller;
    }

    private Font getDefaultFont() {
        return JFaceResources.getDefaultFont();
    }

    private FontData[] getDefaultFontData() {
        return JFaceResources.getDefaultFont().getFontData();
    }

    private Color getErrorColor() {
        return JFaceColors.getErrorText(this.getControl().getDisplay());
    }

    protected boolean getExpanded(Item item) {
        return true;
    }

    private String getFinishedString(JobTreeElement jte, String name, boolean withTime) {
        String time = null;
        if (withTime) {
            time = this.getTimeString(jte);
        }
        if (time != null) {
            return NLS.bind(ProgressMessages.JobInfo_FinishedAt, name, time);
        }
        return NLS.bind(ProgressMessages.JobInfo_Finished, name);
    }

    private Color getHighlightColor() {
        return JFaceColors.getErrorText(this.getControl().getDisplay());
    }

    private Color getHyperlinkColor() {
        return JFaceColors.getHyperlinkText(this.getControl().getDisplay());
    }

    protected Item getItem(int x, int y) {
        return null;
    }

    protected int getItemCount(Control widget) {
        return 1;
    }

    protected int getItemCount(Item item) {
        return 0;
    }

    protected Item[] getItems(Item item) {
        return new Item[0];
    }

    private String getJobNameAndStatus(JobInfo ji, Job job, boolean terminated, boolean withTime) {
        String name = job.getName();
        if (job.isSystem()) {
            name = NLS.bind(ProgressMessages.JobInfo_System, name);
        }
        if (ji.isCanceled()) {
            return NLS.bind(ProgressMessages.JobInfo_Cancelled, name);
        }
        if (terminated) {
            return this.getFinishedString(ji, name, withTime);
        }
        if (ji.isBlocked()) {
            IStatus blockedStatus = ji.getBlockedStatus();
            return NLS.bind(ProgressMessages.JobInfo_Blocked, name, blockedStatus.getMessage());
        }
        switch (job.getState()) {
            case 4: {
                return name;
            }
            case 1: {
                return NLS.bind(ProgressMessages.JobInfo_Sleeping, name);
            }
        }
        return NLS.bind(ProgressMessages.JobInfo_Waiting, name);
    }

    protected Item getParentItem(Item item) {
        return null;
    }

    public ISelection getSelection() {
        if (this.list.isDisposed()) {
            return new StructuredSelection();
        }
        ArrayList<JobTreeElement> l = new ArrayList<JobTreeElement>();
        Control[] cs = this.list.getChildren();
        int i = 0;
        while (i < cs.length) {
            JobItem ji = (JobItem)cs[i];
            l.add(ji.jobTreeElement);
            ++i;
        }
        return new StructuredSelection(l);
    }

    protected Item[] getSelection(Control widget) {
        return new Item[0];
    }

    private Control[] getSortedChildren() {
        Control[] cs = this.list.getChildren();
        ViewerSorter vs = this.getSorter();
        if (vs != null) {
            HashMap<Object, JobItem> map2 = new HashMap<Object, JobItem>();
            Object[] elements = new JobTreeElement[cs.length];
            int i = 0;
            while (i < cs.length) {
                JobItem ji = (JobItem)cs[i];
                elements[i] = ji.jobTreeElement;
                map2.put(elements[i], ji);
                ++i;
            }
            vs.sort(this, elements);
            i = 0;
            while (i < cs.length) {
                cs[i] = (JobItem)map2.get(elements[i]);
                ++i;
            }
        }
        return cs;
    }

    private String getTimeString(JobTreeElement jte) {
        Date date = this.finishedJobs.getFinishDate(jte);
        if (date != null) {
            return DateFormat.getTimeInstance(3).format(date);
        }
        return null;
    }

    public Tree getTree() {
        Tree t = super.getTree();
        if (t != null && !t.isDisposed()) {
            return t;
        }
        return null;
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
    }

    private boolean jobFiltered(JobInfo ji) {
        Job job = ji.getJob();
        if (job != null && job == this.highlightJob) {
            return false;
        }
        if (job == null || job.getState() == 1) {
            return true;
        }
        if (job.isSystem()) {
            if (this.getContentProvider() instanceof ProgressContentProvider) {
                return !((ProgressContentProvider)this.getContentProvider()).debug();
            }
            return false;
        }
        return false;
    }

    protected Item newItem(Widget parent, int flags, int ix) {
        return null;
    }

    public void refresh(boolean updateLabels) {
        if (this.list.isDisposed()) {
            return;
        }
        boolean changed = false;
        boolean countChanged = false;
        JobTreeItem lastAdded = null;
        Object[] roots = this.contentProviderGetRoots(this.getInput());
        HashSet<Object> modelJobs = new HashSet<Object>();
        int z = 0;
        while (z < roots.length) {
            modelJobs.add(roots[z]);
            ++z;
        }
        Control[] children = this.list.getChildren();
        int i = 0;
        while (i < children.length) {
            JobItem ji = (JobItem)children[i];
            if (modelJobs.contains(ji.jobTreeElement)) {
                changed |= ji.refresh();
            } else if (ji.remove()) {
                changed = true;
                countChanged = true;
            }
            ++i;
        }
        i = 0;
        while (i < roots.length) {
            Object element = roots[i];
            if (!this.filtered(element) && this.findJobItem(element, false) == null) {
                lastAdded = this.createItem(element);
                countChanged = true;
                changed = true;
            }
            ++i;
        }
        if (!this.dialogContext) {
            JobTreeElement[] infos = this.finishedJobs.getJobInfos();
            int i2 = 0;
            while (i2 < infos.length) {
                JobTreeItem jte;
                JobTreeElement element = infos[i2];
                if (!this.filtered(element) && (jte = this.findJobItem(element, true)) != null) {
                    jte.setKept();
                    lastAdded = jte;
                    if (jte instanceof Hyperlink) {
                        JobItem p = (JobItem)jte.getParent();
                        p.setKept();
                        lastAdded = p;
                    }
                    countChanged = true;
                    changed = true;
                }
                ++i2;
            }
        }
        this.relayout(changed, countChanged);
        if (lastAdded != null) {
            this.reveal(lastAdded);
        }
    }

    public void refresh(Object element, boolean updateLabels) {
        if (this.list.isDisposed()) {
            return;
        }
        if (this.filtered(element)) {
            return;
        }
        JobTreeItem ji = this.findJobItem(element, false);
        if (ji == null) {
            ji = this.findJobItem(element, true);
            this.relayout(true, true);
        } else if (ji.refresh()) {
            this.relayout(true, true);
        }
    }

    private void relayout(boolean layout, boolean refreshBackgrounds) {
        if (layout) {
            ListLayout l = (ListLayout)this.list.getLayout();
            l.refreshBackgrounds = refreshBackgrounds;
            Point size = this.list.computeSize(this.list.getClientArea().x, -1);
            this.list.setSize(size);
            this.scroller.setMinSize(size);
        }
    }

    public void remove(Object[] elements) {
        if (this.list.isDisposed()) {
            return;
        }
        boolean changed = false;
        int i = 0;
        while (i < elements.length) {
            JobTreeItem ji = this.findJobItem(elements[i], false);
            if (ji != null) {
                changed |= ji.remove();
            }
            ++i;
        }
        this.relayout(changed, changed);
    }

    protected void removeAll(Control widget) {
    }

    public void removed(final JobTreeElement info) {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (info != null) {
                        JobTreeItem ji = NewProgressViewer.this.findJobItem(info, false);
                        if (ji != null && ji.jobTerminated) {
                            ji.dispose();
                            NewProgressViewer.this.relayout(true, true);
                        }
                    } else {
                        Control[] children = NewProgressViewer.this.list.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            JobItem ji = (JobItem)children[i];
                            if (ji.jobTerminated) {
                                ji.dispose();
                            }
                            ++i;
                        }
                        NewProgressViewer.this.relayout(true, true);
                    }
                }
            });
        }
    }

    public void reveal(JobTreeItem jti) {
        if (jti != null && !jti.isDisposed()) {
            Rectangle bounds = jti.getBounds();
            int s = bounds.y;
            int e = bounds.y + bounds.height;
            int as = this.scroller.getOrigin().y;
            int ae = as + this.scroller.getClientArea().height;
            if (s < as) {
                this.scroller.setOrigin(0, s);
            } else if (e > ae) {
                this.scroller.setOrigin(0, as + (e - ae));
            }
        }
    }

    private void select(JobItem newSelection, Event e) {
        JobItem ji;
        int i;
        boolean clearAll = false;
        JobItem newSel = null;
        Control[] cs = this.getSortedChildren();
        if (newSelection != null) {
            JobTreeElement cfr_ignored_0 = newSelection.jobTreeElement;
        }
        if (e.type == 1) {
            if (e.keyCode == 0x1000001) {
                i = 0;
                while (i < cs.length) {
                    ji = (JobItem)cs[i];
                    if (ji.selected) {
                        if (i - 1 >= 0) {
                            newSel = (JobItem)cs[i - 1];
                            if ((e.stateMask & SWT.MOD2) != 0) {
                                newSel.selected = true;
                                break;
                            }
                            clearAll = true;
                            break;
                        }
                        return;
                    }
                    ++i;
                }
                if (newSel == null && cs.length > 0) {
                    newSel = (JobItem)cs[cs.length - 1];
                    newSel.selected = true;
                }
            } else if (e.keyCode == 0x1000002) {
                i = cs.length - 1;
                while (i >= 0) {
                    ji = (JobItem)cs[i];
                    if (ji.selected) {
                        if (i + 1 < cs.length) {
                            newSel = (JobItem)cs[i + 1];
                            if ((e.stateMask & SWT.MOD2) != 0) {
                                newSel.selected = true;
                                break;
                            }
                            clearAll = true;
                            break;
                        }
                        return;
                    }
                    --i;
                }
                if (newSel == null && cs.length > 0) {
                    newSel = (JobItem)cs[0];
                    newSel.selected = true;
                }
            }
        } else if (e.type == 3) {
            if (newSelection == null) {
                clearAll = true;
            } else if ((e.stateMask & SWT.MOD1) != 0) {
                newSelection.selected = !newSelection.selected;
            } else if ((e.stateMask & SWT.MOD2) == 0) {
                if (newSelection.selected) {
                    return;
                }
                clearAll = true;
                newSel = newSelection;
            }
        }
        if (clearAll) {
            i = 0;
            while (i < cs.length) {
                ji = (JobItem)cs[i];
                boolean bl = ji == newSel;
                ji.selected = bl;
                ++i;
            }
        }
        boolean dark = cs.length % 2 == 1;
        int i2 = 0;
        while (i2 < cs.length) {
            JobItem ji2 = (JobItem)cs[i2];
            ji2.updateBackground(dark);
            dark = !dark;
            ++i2;
        }
        if (newSel != null) {
            this.reveal(newSel);
        }
    }

    protected void setExpanded(Item node, boolean expand) {
    }

    public void setFocus() {
        if (this.list != null) {
            Control[] cs = this.list.getChildren();
            int i = 0;
            while (i < cs.length) {
                JobItem ji = (JobItem)cs[i];
                if (ji.selected) {
                    ji.forceFocus();
                    return;
                }
                ++i;
            }
            if (cs.length > 0) {
                cs[0].forceFocus();
            }
        }
    }

    public void setHighlightJob(Job job) {
        this.highlightJob = job;
        this.relayout(true, true);
    }

    public void setInput(IContentProvider provider) {
        this.refresh(true);
    }

    public void setSelection(ISelection selection) {
    }

    protected void setSelection(List items) {
    }

    public void setUseHashlookup(boolean b) {
    }

    protected void showItem(Item item) {
    }

    private String stripPercent(String s) {
        int l = s.length();
        if (l > 0) {
            int pos;
            if (s.charAt(0) == '(') {
                int pos2 = s.indexOf("%) ");
                if (pos2 >= 0) {
                    s = s.substring(pos2 + 3);
                }
            } else if (s.charAt(l - 1) == ')' && (pos = s.lastIndexOf(": (")) >= 0) {
                s = s.substring(0, pos);
            }
        }
        return s;
    }

    class Hyperlink
    extends JobTreeItem
    implements Listener,
    IPropertyChangeListener {
        static final int MARGINHEIGHT = 1;
        static final int MARGINWIDTH = 1;
        boolean foundImage;
        IAction gotoAction;
        boolean hasFocus;
        boolean isError;
        JobItem jobitem;
        boolean linkEnabled;
        boolean mouseOver;
        IStatus result;
        String text = "";

        Hyperlink(JobItem parent, JobTreeElement info) {
            super(parent, info, 262144);
            this.jobitem = parent;
            this.setFont(NewProgressViewer.this.smallerFont);
            this.addListener(1, this);
            this.addListener(9, this);
            this.addListener(6, this);
            this.addListener(7, this);
            this.addListener(3, this);
            this.addListener(4, this);
            this.addListener(15, this);
            this.addListener(16, this);
            this.refresh();
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            this.checkWidget();
            int innerWidth = wHint;
            if (innerWidth != -1) {
                innerWidth -= 2;
            }
            GC gc = new GC(this);
            gc.setFont(this.getFont());
            Point extent = gc.textExtent(this.text);
            gc.dispose();
            return new Point(extent.x + 2, extent.y + 2);
        }

        private Color getFGColor() {
            if (this.jobitem.selected) {
                return NewProgressViewer.this.selectedTextColor;
            }
            if (this.isLinkEnabled()) {
                if (this.isError) {
                    return NewProgressViewer.this.getErrorColor();
                }
                if (this.mouseOver) {
                    return NewProgressViewer.this.getActiveHyperlinkColor();
                }
                return NewProgressViewer.this.getHyperlinkColor();
            }
            return NewProgressViewer.this.textColor;
        }

        protected boolean handleActivate() {
            if (this.isLinkEnabled() && this.gotoAction != null && this.gotoAction.isEnabled()) {
                this.jobitem.locked = true;
                this.gotoAction.run();
                if (this.jobitem.jobTerminated) {
                    this.jobitem.kill();
                }
                return true;
            }
            return false;
        }

        public void handleEvent(Event e) {
            super.handleEvent(e);
            switch (e.type) {
                case 12: {
                    if (this.gotoAction == null) break;
                    this.gotoAction.removePropertyChangeListener(this);
                    this.gotoAction = null;
                    break;
                }
                case 1: {
                    if (e.character == '\r') {
                        this.handleActivate();
                        break;
                    }
                    if (e.keyCode == 127) {
                        NewProgressViewer.this.cancelSelection();
                        break;
                    }
                    NewProgressViewer.this.select(null, e);
                    break;
                }
                case 9: {
                    this.paint(e.gc);
                    break;
                }
                case 15: {
                    this.hasFocus = true;
                }
                case 6: {
                    if (!this.isLinkEnabled()) break;
                    this.mouseOver = true;
                    this.redraw();
                    break;
                }
                case 16: {
                    this.hasFocus = false;
                }
                case 7: {
                    if (!this.isLinkEnabled()) break;
                    this.mouseOver = false;
                    this.redraw();
                    break;
                }
                case 14: {
                    this.handleActivate();
                    break;
                }
                case 3: {
                    if (this.isLinkEnabled()) break;
                    NewProgressViewer.this.select((JobItem)this.getParent(), e);
                    break;
                }
                case 4: {
                    if (!this.isLinkEnabled()) break;
                    Point size = this.getSize();
                    if (e.button != 1 || e.x < 0 || e.y < 0 || e.x >= size.x || e.y >= size.y) {
                        return;
                    }
                    this.handleActivate();
                }
            }
        }

        boolean isLinkEnabled() {
            return !NewProgressViewer.this.dialogContext && this.linkEnabled;
        }

        protected void paint(GC gc) {
            Rectangle clientArea = this.getClientArea();
            if (clientArea.isEmpty()) {
                return;
            }
            Color fg = this.getFGColor();
            Color bg = this.getBackground();
            if (this.jobitem.selected) {
                bg = NewProgressViewer.this.selectedColor;
            }
            Image buffer = null;
            GC bufferGC = gc;
            if (!isCarbon) {
                buffer = new Image((Device)this.getDisplay(), clientArea.width, clientArea.height);
                buffer.setBackground(bg);
                bufferGC = new GC(buffer, gc.getStyle());
            }
            bufferGC.setForeground(fg);
            bufferGC.setBackground(bg);
            bufferGC.fillRectangle(0, 0, clientArea.width, clientArea.height);
            bufferGC.setFont(this.getFont());
            String t = NewProgressViewer.shortenText(bufferGC, clientArea.width, this.text);
            bufferGC.drawText(t, 1, 1, true);
            int sw = bufferGC.stringExtent((String)t).x;
            if (this.isLinkEnabled()) {
                FontMetrics fm = bufferGC.getFontMetrics();
                int lineY = clientArea.height - 1 - fm.getDescent() + 1;
                bufferGC.drawLine(1, lineY, 1 + sw, lineY);
                if (this.hasFocus) {
                    bufferGC.drawFocus(0, 0, sw, clientArea.height);
                }
            }
            if (buffer != null) {
                gc.drawImage(buffer, 0, 0);
                bufferGC.dispose();
                buffer.dispose();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.gotoAction != null) {
                this.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ Hyperlink this$1;
                    {
                        this.this$1 = hyperlink;
                    }

                    public void run() {
                        if (!this.this$1.isDisposed()) {
                            this.this$1.checkKeep();
                            Hyperlink.access$0(this.this$1, this.this$1.gotoAction != null && this.this$1.gotoAction.isEnabled());
                        }
                    }
                });
            }
        }

        public boolean refresh() {
            if (this.jobTreeElement == null) {
                return false;
            }
            Job job = this.getJob();
            if (job != null) {
                IStatus status;
                Object property;
                if (this.jobitem.image == null) {
                    this.jobitem.updateIcon(job);
                }
                if ((property = job.getProperty(IProgressConstants.ACTION_PROPERTY)) instanceof IAction) {
                    this.setAction((IAction)property);
                }
                if ((status = job.getResult()) != null && status != this.result) {
                    this.result = status;
                    if (this.result.getSeverity() == 4) {
                        this.setKeep();
                        this.isError = true;
                        this.setAction(new Action(this, job){
                            final /* synthetic */ Hyperlink this$1;
                            private final /* synthetic */ Job val$job;
                            {
                                this.this$1 = hyperlink;
                                this.val$job = job;
                            }

                            private ErrorNotificationManager getManager() {
                                return ProgressManager.getInstance().errorManager;
                            }

                            public void run() {
                                String title = ProgressMessages.NewProgressView_errorDialogTitle;
                                String msg = ProgressMessages.NewProgressView_errorDialogMessage;
                                if (!this.getManager().showErrorFor(this.val$job, title, msg)) {
                                    ErrorDialog.openError(this.this$1.getShell(), title, msg, this.this$1.result);
                                }
                            }
                        });
                    }
                }
            }
            this.checkKeep();
            String name = null;
            if (this.jobTreeElement instanceof SubTaskInfo) {
                TaskInfo ti;
                SubTaskInfo sti = (SubTaskInfo)this.jobTreeElement;
                String taskName = null;
                if (sti.jobInfo != null && (ti = sti.jobInfo.getTaskInfo()) != null) {
                    taskName = ti.getTaskName();
                }
                if (this.jobTerminated && this.result != null) {
                    name = this.result.getMessage();
                    if (taskName != null && taskName.trim().length() > 0) {
                        name = NLS.bind(ProgressMessages.JobInfo_TaskFormat, taskName, name);
                    }
                } else {
                    name = this.jobTreeElement.getDisplayString();
                    if (taskName != null && taskName.trim().length() > 0) {
                        name = NLS.bind(ProgressMessages.JobInfo_TaskFormat2, taskName, name);
                    }
                }
                if (name.length() == 0) {
                    this.dispose();
                    return true;
                }
            } else if (this.jobTreeElement instanceof JobInfo) {
                JobInfo ji = (JobInfo)this.jobTreeElement;
                if (this.result != null) {
                    name = this.result.getMessage();
                    if ((name == null || name.trim().length() == 0 || "OK".equals(name)) && !this.keepItem) {
                        this.dispose();
                        return true;
                    }
                } else {
                    boolean hasSubTask;
                    JobTreeElement sub;
                    name = NewProgressViewer.this.getJobNameAndStatus(ji, job, this.jobTerminated, false);
                    String taskName = null;
                    TaskInfo info = ji.getTaskInfo();
                    if (info != null) {
                        taskName = info.getTaskName();
                        int percent = info.getPercentDone();
                        if (percent >= 0 && percent <= 100) {
                            taskName = taskName != null ? NLS.bind(ProgressMessages.JobInfo_Percent, Integer.toString(percent), taskName) : NLS.bind(ProgressMessages.JobInfo_Percent2, Integer.toString(percent));
                        }
                    }
                    String subTaskName = null;
                    Object[] subtasks = ji.getChildren();
                    if (subtasks != null && subtasks.length > 0 && (sub = (JobTreeElement)subtasks[0]) != null) {
                        subTaskName = sub.getDisplayString();
                    }
                    boolean hasTask = taskName != null && taskName.trim().length() > 0;
                    boolean bl = hasSubTask = subTaskName != null && subTaskName.trim().length() > 0;
                    if (hasTask && hasSubTask) {
                        name = NLS.bind(ProgressMessages.JobInfo_Format, new Object[]{name, taskName, subTaskName});
                    } else if (hasTask) {
                        name = NLS.bind(ProgressMessages.JobInfo_TaskFormat, name, taskName);
                    } else if (hasSubTask) {
                        name = NLS.bind(ProgressMessages.JobInfo_TaskFormat, name, subTaskName);
                    }
                }
                if (NewProgressViewer.this.highlightJob == job) {
                    NewProgressViewer.this.highlightItem = this.jobitem;
                }
            }
            if (name == null) {
                name = this.jobTreeElement.getDisplayString();
            }
            this.setText(name);
            return false;
        }

        private void setAction(IAction action) {
            if (action == this.gotoAction) {
                return;
            }
            if (this.gotoAction != null) {
                this.gotoAction.removePropertyChangeListener(this);
            }
            this.gotoAction = action;
            if (this.gotoAction != null) {
                String actionName = this.gotoAction.getClass().getName();
                if (actionName.indexOf("RefreshSubscriberJob$2") >= 0) {
                    this.gotoAction.setEnabled(false);
                }
                this.gotoAction.addPropertyChangeListener(this);
            }
            this.updateToolTip();
            this.setLinkEnable(action != null && action.isEnabled());
        }

        private void setLinkEnable(boolean enable) {
            if (enable != this.linkEnabled) {
                this.linkEnabled = enable;
                if (this.isLinkEnabled()) {
                    this.setCursor(NewProgressViewer.this.handCursor);
                }
                this.updateToolTip();
                this.redraw();
            }
        }

        private void setText(String t) {
            if (t == null) {
                t = "";
            }
            if (!t.equals(this.text)) {
                this.text = t;
                this.updateToolTip();
                this.redraw();
            }
        }

        private void updateToolTip() {
            String oldtt;
            String tooltip;
            String tt = this.text;
            if (this.isLinkEnabled() && this.gotoAction != null && this.gotoAction.isEnabled() && (tooltip = this.gotoAction.getToolTipText()) != null && tooltip.trim().length() > 0) {
                tt = tooltip;
            }
            if ((oldtt = this.getToolTipText()) == null || !oldtt.equals(tt)) {
                this.setToolTipText(tt);
            }
        }

        static /* synthetic */ void access$0(Hyperlink hyperlink, boolean bl) {
            hyperlink.setLinkEnable(bl);
        }
    }

    class JobItem
    extends JobTreeItem {
        static final int HGAP = 7;
        static final int MARGIN = 2;
        static final int MAX_PROGRESS_HEIGHT = 12;
        static final int MIN_ICON_SIZE = 16;
        static final int VGAP = 1;
        ToolBar actionBar;
        ToolItem actionButton;
        int cachedHeight = -1;
        int cachedWidth = -1;
        private boolean disposeImage;
        ToolItem gotoButton;
        Label iconItem;
        private Image image;
        private boolean locked;
        Label nameItem;
        ProgressBar progressBar;
        boolean selected;

        JobItem(Composite parent, JobTreeElement info) {
            super(parent, info, 0);
            Assert.isNotNull(info);
            this.getDisplay();
            this.iconItem = new Label(this, 0);
            this.iconItem.addListener(3, this);
            this.updateIcon(this.getJob());
            if (this.image == null) {
                this.iconItem.setImage(NewProgressViewer.this.defaultJobIcon);
            }
            this.nameItem = new Label(this, 0);
            this.nameItem.setFont(NewProgressViewer.this.boldFont);
            this.nameItem.addListener(3, this);
            this.actionBar = new ToolBar(this, 0x800000);
            this.actionBar.setCursor(NewProgressViewer.this.normalCursor);
            this.actionButton = new ToolItem(this.actionBar, 0);
            this.actionButton.setImage(NewProgressViewer.this.cancelJobIcon);
            this.actionButton.setDisabledImage(NewProgressViewer.this.cancelJobDIcon);
            this.actionButton.setToolTipText(ProgressMessages.NewProgressView_CancelJobToolTip);
            this.actionButton.addSelectionListener(new SelectionAdapter(this){
                final /* synthetic */ JobItem this$1;
                {
                    this.this$1 = jobItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.actionButton.setEnabled(false);
                    this.this$1.cancelOrRemove();
                }
            });
            this.addListener(3, this);
            this.addListener(1, this);
            this.addControlListener(new ControlAdapter(this){
                final /* synthetic */ JobItem this$1;
                {
                    this.this$1 = jobItem;
                }

                public void controlResized(ControlEvent e) {
                    this.this$1.handleResize();
                }
            });
            this.refresh();
        }

        private boolean aboutToKeep() {
            boolean changed = false;
            if (this.progressBar != null && !this.progressBar.isDisposed()) {
                this.progressBar.setSelection(100);
                this.progressBar.dispose();
                changed = true;
            }
            if (!this.actionButton.isDisposed()) {
                this.actionButton.setImage(NewProgressViewer.this.clearJobIcon);
                this.actionButton.setDisabledImage(NewProgressViewer.this.clearJobDIcon);
                this.actionButton.setToolTipText(ProgressMessages.NewProgressView_RemoveJobToolTip);
                this.actionButton.setEnabled(true);
                changed = true;
            }
            changed |= this.refresh();
            Control[] c = this.getChildren();
            int i = 0;
            while (i < c.length) {
                if (c[i] instanceof JobTreeItem) {
                    changed |= ((JobTreeItem)c[i]).refresh();
                }
                ++i;
            }
            return changed;
        }

        boolean cancelOrRemove() {
            if (this.jobTerminated) {
                return this.kill();
            }
            this.jobTreeElement.cancel();
            return false;
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            if (changed || this.cachedHeight <= 0 || this.cachedWidth <= 0) {
                Point e1 = this.iconItem.computeSize(-1, -1);
                e1.x = 16;
                Point e2 = this.nameItem.computeSize(-1, -1);
                this.cachedWidth = 2 + e1.x + 7 + 100 + 2;
                this.cachedHeight = 2 + Math.max(e1.y, e2.y);
                if (this.progressBar != null && !this.progressBar.isDisposed()) {
                    ++this.cachedHeight;
                    Point e3 = this.progressBar.computeSize(-1, -1);
                    e3.y = 12;
                    this.cachedHeight += 1 + e3.y;
                }
                Control[] cs = this.getChildren();
                int i = 0;
                while (i < cs.length) {
                    if (cs[i] instanceof Hyperlink) {
                        Point e4 = cs[i].computeSize(-1, -1);
                        this.cachedHeight += 1 + e4.y;
                    }
                    ++i;
                }
                this.cachedHeight += 2;
            }
            int w = wHint == -1 ? this.cachedWidth : wHint;
            int h = hHint == -1 ? this.cachedHeight : hHint;
            return new Point(w, h);
        }

        void createChild(JobTreeElement jte) {
            if (!this.locked) {
                new Hyperlink(this, jte);
            }
        }

        private String getGroupHeader(GroupInfo gi) {
            String name = NewProgressViewer.this.stripPercent(this.jobTreeElement.getDisplayString());
            if (this.jobTerminated) {
                return NewProgressViewer.this.getFinishedString(gi, name, true);
            }
            return name;
        }

        IStatus getResult() {
            Job job;
            if (this.jobTerminated && (job = this.getJob()) != null) {
                return job.getResult();
            }
            return null;
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    super.handleEvent(event);
                    if (this.disposeImage && this.image != null && !this.image.isDisposed()) {
                        this.image.dispose();
                    }
                    this.image = null;
                    break;
                }
                case 1: {
                    if (event.character == '\r') {
                        NewProgressViewer.this.doSelection();
                        break;
                    }
                    if (event.character == '\t') {
                        NewProgressViewer.this.scroller.getParent().forceFocus();
                        break;
                    }
                    if (event.keyCode == 127) {
                        NewProgressViewer.this.cancelSelection();
                        break;
                    }
                    NewProgressViewer.this.select(null, event);
                    break;
                }
                case 3: {
                    this.forceFocus();
                    NewProgressViewer.this.select(this, event);
                    break;
                }
                default: {
                    super.handleEvent(event);
                }
            }
        }

        void handleResize() {
            Point e = this.getSize();
            Point e1 = this.iconItem.computeSize(-1, -1);
            e1.x = 16;
            Point e2 = this.nameItem.computeSize(-1, -1);
            Point e5 = this.actionBar.computeSize(-1, -1);
            int iw = e.x - 2 - 7 - e5.x - 2;
            int indent = 23;
            int y = 2;
            int h = Math.max(e1.y, e2.y);
            this.nameItem.setBounds(2 + e1.x + 7, y + (h - e2.y) / 2, iw - e1.x - 7, e2.y);
            y += h;
            if (this.progressBar != null && !this.progressBar.isDisposed()) {
                Point e3 = this.progressBar.computeSize(-1, -1);
                e3.y = 12;
                this.progressBar.setBounds(2 + indent, y += 2, iw - indent, e3.y);
                y += e3.y;
            }
            Control[] cs = this.getChildren();
            int i = 0;
            while (i < cs.length) {
                if (cs[i] instanceof Hyperlink) {
                    Point e4 = cs[i].computeSize(-1, -1);
                    cs[i].setBounds(2 + indent, ++y, iw - indent, e4.y);
                    y += e4.y;
                }
                ++i;
            }
            int hm = 4;
            int vm = (y - e1.y) / 2;
            if (hm < (y - e1.y) / 2) {
                vm = hm;
            }
            this.iconItem.setBounds(hm, vm, e1.x, e1.y);
            this.actionBar.setBounds(e.x - 2 - e5.x, (e.y - e5.y) / 2, e5.x, e5.y);
        }

        boolean isCanceled() {
            if (this.jobTreeElement instanceof JobInfo) {
                return ((JobInfo)this.jobTreeElement).isCanceled();
            }
            return false;
        }

        public boolean kill() {
            if (this.jobTerminated && !NewProgressViewer.this.finishedJobs.remove(this.jobTreeElement)) {
                this.dispose();
                NewProgressViewer.this.relayout(true, true);
                return true;
            }
            return false;
        }

        public boolean refresh() {
            TaskInfo ti;
            if (this.isDisposed()) {
                return false;
            }
            boolean changed = false;
            boolean isGroup = this.jobTreeElement instanceof GroupInfo;
            Object[] roots = NewProgressViewer.this.contentProviderGetChildren(this.jobTreeElement);
            Job job = this.getJob();
            this.checkKeep();
            if (this.image == null && job != null) {
                this.updateIcon(job);
            }
            String name = null;
            if (isGroup) {
                name = this.getGroupHeader((GroupInfo)this.jobTreeElement);
            } else if (this.jobTreeElement instanceof JobInfo) {
                name = NewProgressViewer.this.getJobNameAndStatus((JobInfo)this.jobTreeElement, job, this.jobTerminated, true);
            }
            if (name == null) {
                name = NewProgressViewer.this.stripPercent(this.jobTreeElement.getDisplayString());
            }
            if (NewProgressViewer.this.highlightJob != null && (NewProgressViewer.this.highlightJob == job || NewProgressViewer.this.highlightItem == this)) {
                name = NLS.bind(ProgressMessages.JobInfo_BlocksUserOperationFormat, name);
            }
            this.nameItem.setToolTipText(name);
            this.nameItem.setText(NewProgressViewer.shortenText(this.nameItem, name));
            if (this.jobTreeElement instanceof JobInfo) {
                ti = ((JobInfo)this.jobTreeElement).getTaskInfo();
                if (ti != null) {
                    changed |= this.setPercentDone(ti.getPercentDone());
                }
            } else if (isGroup) {
                if (roots.length == 1 && roots[0] instanceof JobTreeElement) {
                    ti = ((JobInfo)roots[0]).getTaskInfo();
                    if (ti != null) {
                        changed |= this.setPercentDone(ti.getPercentDone());
                    }
                } else {
                    GroupInfo gi = (GroupInfo)this.jobTreeElement;
                    changed |= this.setPercentDone(gi.getPercentDone());
                }
            }
            if (!this.jobTreeElement.hasChildren()) {
                return changed;
            }
            Control[] children = this.getChildren();
            int n = 0;
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof Hyperlink) {
                    ++n;
                }
                ++i;
            }
            if (!isGroup && roots.length == n) {
                int z = 0;
                int i2 = 0;
                while (i2 < children.length) {
                    if (children[i2] instanceof Hyperlink) {
                        Hyperlink l = (Hyperlink)children[i2];
                        l.init((JobTreeElement)roots[z++]);
                    }
                    ++i2;
                }
            } else {
                HashSet<Object> modelJobs = new HashSet<Object>();
                int z = 0;
                while (z < roots.length) {
                    modelJobs.add(roots[z]);
                    ++z;
                }
                HashSet<JobTreeElement> shownJobs = new HashSet<JobTreeElement>();
                int i3 = 0;
                while (i3 < children.length) {
                    if (children[i3] instanceof Hyperlink) {
                        JobTreeItem ji = (JobTreeItem)children[i3];
                        shownJobs.add(ji.jobTreeElement);
                        if (modelJobs.contains(ji.jobTreeElement)) {
                            ji.refresh();
                        } else {
                            changed |= ji.remove();
                        }
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < roots.length) {
                    Object element = roots[i3];
                    if (!shownJobs.contains(element)) {
                        this.createChild((JobTreeElement)element);
                        changed = true;
                    }
                    ++i3;
                }
            }
            return changed;
        }

        public boolean remove() {
            this.jobTerminated = true;
            if (NewProgressViewer.this.finishedJobs.isFinished(this.jobTreeElement)) {
                this.keepItem = true;
            }
            Control[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof JobTreeItem) {
                    ((JobTreeItem)children[i]).jobTerminated = true;
                }
                ++i;
            }
            if (!NewProgressViewer.this.dialogContext) {
                if (!this.keepItem) {
                    this.checkKeep();
                }
                if (this.keepItem) {
                    return this.aboutToKeep();
                }
            }
            return super.remove();
        }

        boolean setPercentDone(int percentDone) {
            if (percentDone >= 0 && percentDone < 100) {
                if (this.progressBar == null) {
                    this.progressBar = new ProgressBar(this, 256);
                    this.progressBar.setMaximum(100);
                    this.progressBar.setSelection(percentDone);
                    this.progressBar.addListener(3, this);
                    return true;
                }
                if (!this.progressBar.isDisposed()) {
                    this.progressBar.setSelection(percentDone);
                }
            } else if (this.progressBar == null) {
                this.progressBar = new ProgressBar(this, 258);
                this.progressBar.addListener(3, this);
                return true;
            }
            return false;
        }

        void updateBackground(boolean dark) {
            Color bg;
            Color fg;
            if (this.selected) {
                fg = NewProgressViewer.this.selectedTextColor;
                bg = NewProgressViewer.this.selectedColor;
            } else {
                fg = NewProgressViewer.this.highlightJob != null && (NewProgressViewer.this.highlightJob == this.getJob() || NewProgressViewer.this.highlightItem == this) ? NewProgressViewer.this.getHighlightColor() : NewProgressViewer.this.textColor;
                bg = dark ? NewProgressViewer.this.darkColor : NewProgressViewer.this.lightColor;
            }
            this.setForeground(fg);
            this.setBackground(bg);
            Control[] cs = this.getChildren();
            int i = 0;
            while (i < cs.length) {
                if (!(cs[i] instanceof ProgressBar)) {
                    cs[i].setForeground(fg);
                    cs[i].setBackground(bg);
                }
                ++i;
            }
        }

        void updateIcon(Job job) {
            if (job != null) {
                Image im = null;
                boolean dispImage = false;
                Display display = this.getDisplay();
                Object property = job.getProperty(ICON_PROPERTY);
                if (property instanceof ImageDescriptor) {
                    dispImage = true;
                    im = ((ImageDescriptor)property).createImage(display);
                } else if (property instanceof URL) {
                    dispImage = true;
                    im = ImageDescriptor.createFromURL((URL)property).createImage(display);
                } else {
                    dispImage = false;
                    im = ProgressManager.getInstance().getIconFor(job);
                }
                if (im != null && im != this.image) {
                    if (this.disposeImage && this.image != null) {
                        this.image.dispose();
                    }
                    this.image = im;
                    this.disposeImage = dispImage;
                    if (this.iconItem != null) {
                        this.iconItem.setImage(this.image);
                    }
                }
            }
        }
    }

    abstract class JobTreeItem
    extends Canvas
    implements Listener {
        boolean jobTerminated;
        JobTreeElement jobTreeElement;
        boolean keepItem;

        JobTreeItem(Composite parent, JobTreeElement info, int flags) {
            super(parent, flags);
            this.jobTreeElement = info;
            NewProgressViewer.this.map.put(this.jobTreeElement, this);
            this.addListener(12, this);
        }

        boolean checkKeep() {
            if (this.jobTreeElement instanceof JobInfo && FinishedJobs.keep((JobInfo)this.jobTreeElement)) {
                this.setKeep();
            }
            return this.keepItem;
        }

        protected void dump(String message) {
        }

        Job getJob() {
            if (this.jobTreeElement instanceof JobInfo) {
                return ((JobInfo)this.jobTreeElement).getJob();
            }
            if (this.jobTreeElement instanceof SubTaskInfo) {
                return ((SubTaskInfo)this.jobTreeElement).jobInfo.getJob();
            }
            return null;
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 12: {
                    NewProgressViewer.this.map.remove(this.jobTreeElement);
                }
            }
        }

        void init(JobTreeElement info) {
            if (this.jobTreeElement != info) {
                NewProgressViewer.this.map.remove(this.jobTreeElement);
                this.jobTreeElement = info;
                NewProgressViewer.this.map.put(this.jobTreeElement, this);
            }
            this.refresh();
        }

        public boolean kill() {
            return true;
        }

        abstract boolean refresh();

        public boolean remove() {
            this.jobTerminated = true;
            this.refresh();
            if (NewProgressViewer.this.dialogContext || !this.keepItem) {
                this.dispose();
                return true;
            }
            return false;
        }

        void setKeep() {
            this.keepItem = true;
            Composite parent = this.getParent();
            if (parent instanceof JobTreeItem) {
                ((JobTreeItem)parent).keepItem = true;
            }
        }

        void setKept() {
            if (!this.jobTerminated) {
                this.jobTerminated = true;
                this.keepItem = true;
                this.remove();
            }
        }
    }

    class ListLayout
    extends Layout {
        static final int VERTICAL_SPACING = 1;
        boolean refreshBackgrounds;

        ListLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int w = 0;
            int h = -1;
            Control[] cs = composite.getChildren();
            int i = 0;
            while (i < cs.length) {
                Control c = cs[i];
                Point e = c.computeSize(-1, -1, flushCache);
                w = Math.max(w, e.x);
                h += e.y + 1;
                ++i;
            }
            return new Point(w, h);
        }

        protected void layout(Composite composite, boolean flushCache) {
            int x = 0;
            int y = 0;
            Point e = composite.getSize();
            Control[] cs = NewProgressViewer.this.getSortedChildren();
            boolean dark = cs.length % 2 == 1;
            int i = 0;
            while (i < cs.length) {
                Control c = cs[i];
                Point s = c.computeSize(e.x, -1, flushCache);
                c.setBounds(x, y, s.x, s.y);
                y += s.y + 1;
                if (this.refreshBackgrounds && c instanceof JobItem) {
                    ((JobItem)c).updateBackground(dark);
                    dark = !dark;
                }
                ++i;
            }
        }
    }
}

