/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressViewer;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewerLabelProvider;

public class ProgressRegion {
    ProgressViewer viewer;
    AnimationItem item;
    Composite region;
    WorkbenchWindow workbenchWindow;

    public Control createContents(Composite parent, WorkbenchWindow window) {
        this.workbenchWindow = window;
        this.region = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.numColumns = 3;
        this.region.setLayout(gl);
        new Label(this.region, 2);
        this.viewer = new ProgressViewer(this.region, 524288, 1, 36);
        this.viewer.setUseHashlookup(true);
        Control viewerControl = this.viewer.getControl();
        GridData gd = new GridData(1808);
        gd.widthHint = this.viewer.getSizeHints().x;
        viewerControl.setLayoutData(gd);
        int widthPreference = AnimationManager.getInstance().getPreferredWidth() + 25;
        this.item = new ProgressAnimationItem(this);
        this.item.createControl(this.region);
        this.item.setAnimationContainer(new AnimationItem.IAnimationContainer(){

            public void animationDone() {
                if (ProgressRegion.this.viewer.getControl().isDisposed()) {
                    return;
                }
                ProgressRegion.this.viewer.refresh();
            }

            public void animationStart() {
            }
        });
        Control itemControl = this.item.getControl();
        gd = new GridData(1040);
        gd.widthHint = widthPreference;
        itemControl.setLayoutData(gd);
        viewerControl.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProgressRegion.this.processDoubleClick();
            }
        });
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer, false);
        this.viewer.setContentProvider(provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider(new ProgressViewerLabelProvider(viewerControl));
        this.viewer.setSorter(ProgressManagerUtil.getProgressViewerSorter());
        return this.region;
    }

    public AnimationItem getAnimationItem() {
        return this.item;
    }

    public Control getControl() {
        return this.region;
    }

    public void processDoubleClick() {
        ProgressManagerUtil.openProgressView(this.workbenchWindow);
    }
}

