/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class OperationHistoryActionHandler
extends Action
implements ActionFactory.IWorkbenchAction,
IAdaptable {
    private static final int MAX_LABEL_LENGTH = 32;
    private boolean pruning = false;
    private IPartListener partListener = new PartListener();
    private IOperationHistoryListener historyListener = new HistoryListener();
    private TimeTriggeredProgressMonitorDialog progressDialog;
    IUndoContext undoContext = null;
    IWorkbenchPartSite site;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    OperationHistoryActionHandler(IWorkbenchPartSite site, IUndoContext context) {
        super("");
        this.site = site;
        this.undoContext = context;
        site.getPage().addPartListener(this.partListener);
        this.getHistory().addOperationHistoryListener(this.historyListener);
        this.update();
    }

    public void dispose() {
        this.getHistory().removeOperationHistoryListener(this.historyListener);
        this.site.getPage().removePartListener(this.partListener);
        this.site = null;
        this.progressDialog = null;
        this.undoContext = null;
    }

    abstract void flush();

    abstract String getCommandString();

    IOperationHistory getHistory() {
        return this.getWorkbenchWindow().getWorkbench().getOperationSupport().getOperationHistory();
    }

    abstract IUndoableOperation getOperation();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void run() {
        if (this.undoContext == null) return;
        if (this.site == null) {
            return;
        }
        Shell parent = this.getWorkbenchWindow().getShell();
        this.progressDialog = new TimeTriggeredProgressMonitorDialog(parent, this.getWorkbenchWindow().getWorkbench().getProgressService().getLongOperationTime());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    OperationHistoryActionHandler.this.runCommand(pm);
                }
                catch (ExecutionException e) {
                    if (OperationHistoryActionHandler.this.pruning) {
                        OperationHistoryActionHandler.this.flush();
                    }
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.progressDialog.run(false, true, runnable);
            }
            catch (InvocationTargetException e) {
                this.reportException(e);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.progressDialog = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.progressDialog = null;
            return;
        }
    }

    abstract IStatus runCommand(IProgressMonitor var1) throws ExecutionException;

    public Object getAdapter(Class adapter) {
        Class<?> clazz;
        if (this.site != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz2)) {
                return this.getWorkbenchWindow().getShell();
            }
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.ui.IWorkbenchWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz3)) {
                return this.getWorkbenchWindow();
            }
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("org.eclipse.ui.IWorkbenchPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz4)) {
                return this.site.getPart();
            }
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.undoContext;
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.core.runtime.IProgressMonitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz5) && this.progressDialog != null) {
            return this.progressDialog.getProgressMonitor();
        }
        return null;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        if (this.site != null) {
            return this.site.getWorkbenchWindow();
        }
        return null;
    }

    abstract boolean shouldBeEnabled();

    public void setContext(IUndoContext context) {
        this.undoContext = context;
        this.update();
    }

    public void setPruneHistory(boolean prune) {
        this.pruning = prune;
    }

    public void update() {
        boolean enabled = this.shouldBeEnabled();
        String text = this.getCommandString();
        if (enabled) {
            text = NLS.bind(WorkbenchMessages.Operations_undoRedoCommand, text, this.shortenText(this.getOperation().getLabel()));
        } else if (this.undoContext != null && this.pruning) {
            this.flush();
        }
        this.setText(text);
        this.setEnabled(enabled);
    }

    private String shortenText(String message) {
        int length = message.length();
        if (length > 32) {
            StringBuffer result = new StringBuffer();
            int mid = 16;
            result.append(message.substring(0, mid));
            result.append("...");
            result.append(message.substring(length - mid));
            return result.toString();
        }
        return message;
    }

    final void reportException(Exception e) {
        Throwable nestedException = StatusUtil.getCause(e);
        Throwable exception = nestedException == null ? e : nestedException;
        String title = WorkbenchMessages.Error;
        String message = WorkbenchMessages.WorkbenchWindow_exceptionMessage;
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        WorkbenchPlugin.log(message, status);
        ErrorDialog.openError(this.getWorkbenchWindow().getShell(), title, message, status);
    }

    private class PartListener
    implements IPartListener {
        PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part.equals(OperationHistoryActionHandler.this.site.getPart())) {
                OperationHistoryActionHandler.this.dispose();
            } else if (OperationHistoryActionHandler.this.site instanceof MultiPageEditorSite && part.equals(((MultiPageEditorSite)OperationHistoryActionHandler.this.site).getMultiPageEditor())) {
                OperationHistoryActionHandler.this.dispose();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class HistoryListener
    implements IOperationHistoryListener {
        HistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            Display display = OperationHistoryActionHandler.this.getWorkbenchWindow().getWorkbench().getDisplay();
            switch (event.getEventType()) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    if (display == null || !event.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(new Runnable(this){
                        final /* synthetic */ HistoryListener this$1;
                        {
                            this.this$1 = historyListener;
                        }

                        public void run() {
                            HistoryListener.access$0(this.this$1).update();
                        }
                    });
                    break;
                }
                case 7: {
                    if (display == null || !event.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(new Runnable(this){
                        final /* synthetic */ HistoryListener this$1;
                        {
                            this.this$1 = historyListener;
                        }

                        public void run() {
                            if (OperationHistoryActionHandler.access$1(HistoryListener.access$0(this.this$1))) {
                                HistoryListener.access$0(this.this$1).flush();
                                HistoryListener.access$0(this.this$1).update();
                            } else {
                                HistoryListener.access$0(this.this$1).update();
                            }
                        }
                    });
                    break;
                }
                case 6: {
                    if (display == null || event.getOperation() != OperationHistoryActionHandler.this.getOperation()) break;
                    display.asyncExec(new Runnable(this){
                        final /* synthetic */ HistoryListener this$1;
                        {
                            this.this$1 = historyListener;
                        }

                        public void run() {
                            HistoryListener.access$0(this.this$1).update();
                        }
                    });
                }
            }
        }

        static /* synthetic */ OperationHistoryActionHandler access$0(HistoryListener historyListener) {
            return historyListener.OperationHistoryActionHandler.this;
        }
    }
}

