/*
 * Decompiled with CFR 0.152.
 */
package org.gvt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Cursor;
import org.gvt.ChisioMain;
import org.gvt.GraphAnimation;
import org.gvt.action.ZoomAction;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;
import org.ivis.layout.Cluster;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.LayoutOptionsPack;
import org.ivis.util.PointD;

public class LayoutManager {
    private Layout layout;
    private CompoundModel root;
    private ChisioMain main;
    private HashMap<NodeModel, LNode> gvtToLayout = new HashMap();
    private HashMap<LNode, NodeModel> layoutToGvt = new HashMap();
    private static LayoutManager instance = new LayoutManager();

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setRoot(CompoundModel root) {
        this.root = root;
    }

    public void setMain(ChisioMain main) {
        this.main = main;
    }

    public void createTopology() {
        LGraphManager graphMgr = this.layout.getGraphManager();
        LGraph lroot = graphMgr.addRoot();
        lroot.vGraphObject = this.root;
        for (Object o : this.root.getChildren()) {
            this.createNode((NodeModel)o, null, this.layout);
        }
        Map<EdgeModel, Integer> multiEdges = this.findMultiEdges(this.root.getEdges());
        for (Object o : this.root.getEdges()) {
            EdgeModel edge = (EdgeModel)o;
            this.createEdge(edge, multiEdges.get(edge));
        }
        graphMgr.updateBounds();
    }

    private Map<EdgeModel, Integer> findMultiEdges(Set<EdgeModel> edges) {
        HashMap map = new HashMap();
        for (EdgeModel edge1 : edges) {
            for (EdgeModel edge2 : edges) {
                if (edge1 == edge2 || edge1.hashCode() < edge2.hashCode() || (edge1.getSource() != edge2.getSource() || edge1.getTarget() != edge2.getTarget()) && (edge1.getSource() != edge2.getTarget() || edge1.getTarget() != edge2.getSource())) continue;
                HashSet<EdgeModel> set = (HashSet<EdgeModel>)map.get(edge1);
                if (set == null) {
                    set = (Set)map.get(edge2);
                }
                if (set == null) {
                    set = new HashSet<EdgeModel>();
                }
                if (!map.containsKey(edge1)) {
                    map.put(edge1, set);
                }
                if (!map.containsKey(edge2)) {
                    map.put(edge2, set);
                }
                set.add(edge1);
                set.add(edge2);
            }
        }
        HashMap<EdgeModel, Integer> multi = new HashMap<EdgeModel, Integer>();
        for (Set edgeSet : map.values()) {
            int i = 0;
            NodeModel ref = null;
            for (EdgeModel edge : edgeSet) {
                int index = i++;
                if (ref == null) {
                    ref = edge.getSource();
                } else if (edge.getTarget() == ref) {
                    index *= -1;
                }
                multi.put(edge, index);
            }
        }
        return multi;
    }

    private void createNode(NodeModel node, NodeModel parent, Layout layout) {
        LNode lNode = layout.newNode(node);
        LGraph rootGraph = layout.getGraphManager().getRoot();
        this.gvtToLayout.put(node, lNode);
        this.layoutToGvt.put(lNode, node);
        Iterator<Cluster> clusterItr = node.getClusters().iterator();
        while (clusterItr.hasNext()) {
            int clusterID = clusterItr.next().getClusterID();
            lNode.addCluster(clusterID);
        }
        if (parent != null) {
            LNode parentLNode = this.gvtToLayout.get(parent);
            assert (parentLNode.getChild() != null) : "Parent node doesn't have child graph.";
            parentLNode.getChild().add(lNode);
            lNode.label = new String(node.getText());
        } else {
            rootGraph.add(lNode);
            lNode.label = new String(node.getText());
        }
        lNode.setLocation(node.getLocationAbs().x, node.getLocationAbs().y);
        for (Cluster cluster : node.getClusters()) {
            int clusterID = cluster.getClusterID();
            if (clusterID == 0) continue;
            assert (clusterID > 0);
            lNode.addCluster(clusterID);
        }
        if (node instanceof CompoundModel) {
            CompoundModel compoundNode = (CompoundModel)node;
            Iterator nodeIter = compoundNode.getChildren().iterator();
            layout.getGraphManager().add(layout.newGraph(null), lNode);
            while (nodeIter.hasNext()) {
                this.createNode((NodeModel)nodeIter.next(), compoundNode, layout);
            }
            lNode.updateBounds();
        } else {
            lNode.setWidth(node.getSize().width);
            lNode.setHeight(node.getSize().height);
        }
    }

    private void createEdge(EdgeModel edge, Integer bendpointIndex) {
        LEdge lEdge = this.layout.newEdge(edge);
        LNode sourceLNode = this.gvtToLayout.get(edge.getSource());
        LNode targetLNode = this.gvtToLayout.get(edge.getTarget());
        this.layout.getGraphManager().add(lEdge, sourceLNode, targetLNode);
        if (bendpointIndex != null) {
            lEdge.getBendpoints().add(new PointD(bendpointIndex.intValue(), bendpointIndex.intValue()));
        }
    }

    public void preRun() {
        PreRun preRun = new PreRun(this.main);
        this.main.getShell().getDisplay().syncExec(preRun);
    }

    public void postRun() {
        PostRun postRun = new PostRun(this.main);
        this.main.getShell().getDisplay().syncExec(postRun);
    }

    public void animate() {
        if (LayoutOptionsPack.getInstance().getGeneral().animationDuringLayout) {
            DuringRun inRun = new DuringRun(this.main);
            this.main.getShell().getDisplay().syncExec(inRun);
        }
    }

    public void runLayout() {
        this.layout.runLayout();
    }

    public static LayoutManager getInstance() {
        return instance;
    }

    private class PostRun
    implements Runnable {
        private ChisioMain main;

        public PostRun(ChisioMain main) {
            this.main = main;
        }

        @Override
        public void run() {
            if (LayoutOptionsPack.getInstance().getGeneral().animationOnLayout) {
                GraphAnimation.run(this.main.getViewer());
            }
            this.main.getHighlightLayer().setVisible(true);
            this.main.getHandleLayer().setVisible(true);
            this.main.getShell().setCursor(new Cursor(null, 0));
        }
    }

    private class DuringRun
    implements Runnable {
        private ChisioMain main;

        public DuringRun(ChisioMain main) {
            this.main = main;
        }

        @Override
        public void run() {
            new ZoomAction(this.main, 0, null).run();
            GraphAnimation.run(this.main.getViewer());
        }
    }

    private class PreRun
    implements Runnable {
        private ChisioMain main;

        public PreRun(ChisioMain main) {
            this.main = main;
        }

        @Override
        public void run() {
            this.main.getShell().setCursor(new Cursor(null, 1));
            this.main.getHighlightLayer().setVisible(false);
            this.main.getHandleLayer().setVisible(false);
        }
    }
}

