/*
 * Decompiled with CFR 0.152.
 */
package org.gvt;

import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.cbio.causality.data.portal.CBioPortalAccessor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.gvt.ChisioMain;
import org.gvt.action.CBioPortalDataStatisticsAction;
import org.gvt.action.ClosePathwayAction;
import org.gvt.action.DataLegendAction;
import org.gvt.action.DeleteAction;
import org.gvt.action.DeletePathwayAction;
import org.gvt.action.DuplicatePathwayAction;
import org.gvt.action.FetchFromCBioPortalAction;
import org.gvt.action.HighlightCancerGenesActions;
import org.gvt.action.HighlightSIFDifferenceAction;
import org.gvt.action.HighlightSelectedAction;
import org.gvt.action.HighlightTCGACaseAction;
import org.gvt.action.InspectorAction;
import org.gvt.action.LayoutInspectorAction;
import org.gvt.action.LoadSIFLayoutAction;
import org.gvt.action.LoadTCGASpecificReactionsAction;
import org.gvt.action.LocalCommonStreamQueryAction;
import org.gvt.action.LocalGoIQueryAction;
import org.gvt.action.LocalNeighborhoodQueryAction;
import org.gvt.action.QueryPCAction;
import org.gvt.action.QueryPCCommonStreamAction;
import org.gvt.action.QueryPCGetAction;
import org.gvt.action.QueryPCNeighborsAction;
import org.gvt.action.QueryPCPathsBetweenAction;
import org.gvt.action.RemoveColorsAction;
import org.gvt.action.RemoveHighlightFromSelectedAction;
import org.gvt.action.RemoveHighlightsAction;
import org.gvt.action.SaveSIFLayoutAction;
import org.gvt.action.ShowDruggableAction;
import org.gvt.action.ShowFormatSeriesAction;
import org.gvt.action.ShowMutexGroupsAction;
import org.gvt.action.ShowSIFStatisticsAction;
import org.gvt.action.TCGASIFAction;
import org.gvt.action.UpdatePathwayAction;
import org.gvt.action.UpdateTCGASIFForACaseAction;
import org.gvt.action.ZoomAction;
import org.gvt.editpart.ChsEdgeEditPart;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFEdge;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.basicsif.BasicSIFGroup;
import org.gvt.model.basicsif.BasicSIFNode;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.sifl3.SIFEdge;
import org.gvt.model.sifl3.SIFGraph;
import org.gvt.model.sifl3.SIFGroup;
import org.gvt.model.sifl3.SIFNode;
import org.patika.mada.util.ExperimentData;

public class PopupManager
extends MenuManager {
    private Point clickLocation;
    private ChisioMain main;

    public PopupManager(ChisioMain main) {
        this.main = main;
    }

    public void createActions(IMenuManager manager) {
        EditPart ep = this.main.getViewer().findObjectAt(this.clickLocation);
        if (ep instanceof RootEditPart) {
            boolean sif = false;
            boolean tcgasif = false;
            boolean basicsif = false;
            Object o = ((ChsRootEditPart)ep.getChildren().get(0)).getModel();
            if (o instanceof BasicSIFGraph || o instanceof SIFGraph) {
                sif = true;
                basicsif = o instanceof BasicSIFGraph;
                tcgasif = TCGASIFAction.okToRun(this.main, false);
            }
            if (tcgasif) {
                manager.add(new ShowMutexGroupsAction(this.main));
                manager.add(new HighlightTCGACaseAction(this.main));
                manager.add(new UpdateTCGASIFForACaseAction(this.main));
                manager.add(new LoadTCGASpecificReactionsAction(this.main));
                manager.add(new Separator());
            }
            if (basicsif) {
                manager.add(new ShowFormatSeriesAction(this.main));
                manager.add(new Separator());
            }
            if (sif) {
                manager.add(new SaveSIFLayoutAction(this.main));
                manager.add(new LoadSIFLayoutAction(this.main));
                manager.add(new Separator());
                manager.add(new ShowDruggableAction(this.main));
                manager.add(new HighlightCancerGenesActions(this.main));
                manager.add(new HighlightSIFDifferenceAction(this.main));
                manager.add(new ShowSIFStatisticsAction(this.main));
                manager.add(new Separator());
            }
            ClosePathwayAction action = new ClosePathwayAction(this.main);
            if (sif) {
                action.setText("Close Graph");
            }
            manager.add(action);
            if (!sif) {
                manager.add(new DuplicatePathwayAction(this.main));
                manager.add(new DeletePathwayAction(this.main));
                manager.add(new UpdatePathwayAction(this.main, false));
            }
            manager.add(new Separator());
            if (ChisioMain.cBioPortalAccessor != null) {
                manager.add(new FetchFromCBioPortalAction(this.main, "CURRENT_STUDY"));
                manager.add(new Separator());
            }
            manager.add(new ZoomAction(this.main, 1, null));
            manager.add(new ZoomAction(this.main, -1, null));
            manager.add(new Separator());
            manager.add(new RemoveHighlightsAction(this.main));
            if (sif) {
                manager.add(new RemoveColorsAction(this.main));
            }
            manager.add(new InspectorAction(this.main, true));
            manager.add(new Separator());
            manager.add(new LayoutInspectorAction(this.main));
            this.main.getViewer().select(ep);
        } else if (ep instanceof NodeEditPart) {
            ExperimentData data;
            Object o = ep.getModel();
            if (o instanceof BasicSIFGroup && !((BasicSIFGroup)o).getMediators().isEmpty() || o instanceof SIFGroup && !((SIFGroup)o).getMediators().isEmpty()) {
                QueryPCGetAction query = new QueryPCGetAction(this.main, true, QueryPCAction.QueryLocation.PC_MECH);
                query.setText("Detailed View");
                manager.add(query);
                manager.add(new Separator());
            }
            if ((data = DataLegendAction.getData((NodeModel)o, this.main)) != null) {
                manager.add(new DataLegendAction(this.main, data));
            }
            manager.add(new HighlightSelectedAction(this.main));
            manager.add(new RemoveHighlightFromSelectedAction(this.main));
            manager.add(new DeleteAction(this.main));
            manager.add(new InspectorAction(this.main, false));
            manager.add(new Separator());
            MenuManager localQueryMenu = new MenuManager("&Local Query");
            localQueryMenu.add(new LocalNeighborhoodQueryAction(this.main, true));
            localQueryMenu.add(new LocalGoIQueryAction(this.main, true));
            localQueryMenu.add(new LocalCommonStreamQueryAction(this.main, true));
            manager.add(localQueryMenu);
            MenuManager pcQueryMenu = new MenuManager("&Pathway Commons Query (Level 3)");
            MenuManager neighMenu = new MenuManager("&Neighborhood");
            neighMenu.add(new QueryPCNeighborsAction(this.main, false, true, QueryPCAction.QueryLocation.PC_MECH));
            neighMenu.add(new QueryPCNeighborsAction(this.main, true, false, QueryPCAction.QueryLocation.PC_MECH));
            neighMenu.add(new QueryPCNeighborsAction(this.main, true, true, QueryPCAction.QueryLocation.PC_MECH));
            pcQueryMenu.add(neighMenu);
            pcQueryMenu.add(new QueryPCPathsBetweenAction(this.main, true, QueryPCAction.QueryLocation.PC_MECH));
            MenuManager commStreamMenu = new MenuManager("&Common Stream");
            commStreamMenu.add(new QueryPCCommonStreamAction(this.main, true, QueryPCAction.QueryLocation.PC_MECH));
            commStreamMenu.add(new QueryPCCommonStreamAction(this.main, false, QueryPCAction.QueryLocation.PC_MECH));
            pcQueryMenu.add(commStreamMenu);
            manager.add(pcQueryMenu);
            NodeEditPart nep = (NodeEditPart)ep;
            Object model = nep.getModel();
            CBioPortalAccessor portalAccessor = ChisioMain.cBioPortalAccessor;
            if ((model instanceof Actor || model instanceof BasicSIFNode || model instanceof SIFNode) && this.main.hasExperimentData("cBio Portal Alteration Data") && portalAccessor != null && !portalAccessor.getCurrentGeneticProfiles().isEmpty()) {
                manager.add(new Separator());
                manager.add(new CBioPortalDataStatisticsAction(this.main));
            }
        } else if (ep instanceof ChsEdgeEditPart) {
            Object o = ep.getModel();
            if (o instanceof BasicSIFEdge || o instanceof SIFEdge) {
                String tag;
                String string = tag = o instanceof BasicSIFEdge ? ((BasicSIFEdge)o).getTag() : ((SIFEdge)o).getTag();
                if (tag.equals(SIFEnum.IN_COMPLEX_WITH.getTag())) {
                    QueryPCNeighborsAction query = new QueryPCNeighborsAction(this.main, true, true, QueryPCAction.QueryLocation.PC_MECH);
                    query.setText("Detailed View");
                    query.setIgnoreIDsOfSelectedNodes(true);
                    manager.add(query);
                } else {
                    QueryPCGetAction query = new QueryPCGetAction(this.main, true, QueryPCAction.QueryLocation.PC_MECH);
                    query.setText("Detailed View");
                    query.setIgnoreIDsOfSelectedNodes(true);
                    manager.add(query);
                    query = new QueryPCGetAction(this.main, true, QueryPCAction.QueryLocation.FILE_MECH);
                    query.setLocalFilename("/home/babur/Documents/Analyses/CPTACBreastCancer/BigMech/REACH/model.owl");
                    query.setText("Detailed View On Temp Model");
                    manager.add(query);
                }
                manager.add(new Separator());
            }
            manager.add(new HighlightSelectedAction(this.main));
            manager.add(new RemoveHighlightFromSelectedAction(this.main));
            manager.add(new DeleteAction(this.main));
            manager.add(new InspectorAction(this.main, false));
        }
    }

    public void setClickLocation(Point clickLocation) {
        this.clickLocation = clickLocation;
    }
}

