/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsNodeEditPart;
import org.gvt.model.NodeModel;
import org.ivis.layout.Cluster;

public class AssignNewClusterIDAction
extends Action {
    ScrollingGraphicalViewer viewer;
    private ChisioMain main;

    public AssignNewClusterIDAction(ScrollingGraphicalViewer view) {
        super("Assign Selected to New Cluster");
        this.viewer = view;
    }

    public AssignNewClusterIDAction(ChisioMain main) {
        super("Assign Selected to New Cluster");
        this.main = main;
        this.setToolTipText("Assign Selected to New Cluster");
    }

    @Override
    public void run() {
        if (this.main != null) {
            this.viewer = this.main.getViewer();
        }
        Iterator selectedObjects = ((IStructuredSelection)this.viewer.getSelection()).iterator();
        ArrayList<Integer> clusterIDs = this.main.getPathwayGraph().getClusterManager().getClusterIDs();
        int newID = 1;
        for (int i = 0; i < clusterIDs.size() && (Integer)clusterIDs.get(i) <= newID; ++newID, ++i) {
        }
        while (selectedObjects.hasNext()) {
            EditPart childEditPart = (EditPart)selectedObjects.next();
            if (!(childEditPart instanceof ChsNodeEditPart)) continue;
            NodeModel node = (NodeModel)childEditPart.getModel();
            node.resetClusters();
            node.addCluster(newID);
            Cluster cluster = this.main.getPathwayGraph().getClusterManager().getClusterByID(newID);
            cluster.calculatePolygon();
            if (!this.main.isClusterBoundShown) continue;
            this.main.getHighlightLayer().addHighlightToCluster(cluster);
        }
    }
}

