/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.gvt.ChisioMain;

public class ClosePathwayAction
extends Action {
    private ChisioMain main;
    private boolean allOpenPathways;

    public ClosePathwayAction(ChisioMain main, boolean allOpenPathways) {
        super(allOpenPathways ? "Close All Open Pathways" : "Close Pathway");
        if (allOpenPathways) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-close-all.png"));
        } else {
            this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-close.png"));
        }
        this.setToolTipText(this.getText());
        this.main = main;
        this.allOpenPathways = allOpenPathways;
    }

    public ClosePathwayAction(ChisioMain main) {
        this(main, false);
    }

    @Override
    public void run() {
        if (this.allOpenPathways) {
            this.main.closeAllTabs(true);
        } else {
            CTabItem tab = this.main.getSelectedTab();
            if (tab != null) {
                this.main.closeTab(tab, true);
            }
        }
    }
}

