/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.gvt.ChisioMain;
import org.gvt.action.SaveAsImageAction;
import org.gvt.editpart.ChsScalableRootEditPart;

public class CopyToClipboardAction
extends SaveAsImageAction {
    public CopyToClipboardAction(ChisioMain chisio, boolean saveGraph) {
        super(chisio, saveGraph);
        this.setText("Copy " + (saveGraph ? "Pathway" : "View") + " To Clipboard");
    }

    @Override
    public void run() {
        Rectangle bounds;
        Shell shell = this.main.getShell();
        ScalableLayeredPane layer = null;
        if (this.main.getViewer() == null) {
            return;
        }
        Figure rootFigure = (Figure)((ChsScalableRootEditPart)this.main.getViewer().getRootEditPart()).getFigure();
        if (!this.saveWholeGraph) {
            bounds = this.getBounds(rootFigure);
        } else {
            rootFigure = (Figure)rootFigure.getChildren().get(0);
            layer = (ScalableLayeredPane)rootFigure.getChildren().get(0);
            double scale = layer.getScale();
            bounds = CopyToClipboardAction.getBounds(this.main.getViewer(), rootFigure, scale);
        }
        Image image = new Image((Device)shell.getDisplay(), bounds);
        GC gc = new GC(image);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        SWTGraphics graphics = new SWTGraphics(gc);
        rootFigure.paint(graphics);
        ((Graphics)graphics).dispose();
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{new PngTransfer()});
    }

    class PngTransfer
    extends ByteArrayTransfer {
        String IMAGE_PNG = "image/png";
        int ID = PngTransfer.registerType(this.IMAGE_PNG);

        PngTransfer() {
        }

        @Override
        protected String[] getTypeNames() {
            return new String[]{this.IMAGE_PNG};
        }

        @Override
        protected int[] getTypeIds() {
            return new int[]{this.ID};
        }

        @Override
        protected void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof ImageData)) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                ImageData image = (ImageData)object;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    ImageLoader imgLoader = new ImageLoader();
                    imgLoader.data = new ImageData[]{image};
                    imgLoader.save(out, 5);
                    byte[] buffer = out.toByteArray();
                    out.close();
                    super.javaToNative(buffer, transferData);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        protected Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                return new ImageData(in);
            }
            return null;
        }
    }
}

