/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.gui.ItemSelectionDialog;
import org.patika.mada.gui.ExperimentDataManagementDialog;

public class DataManagementAction
extends Action {
    private ChisioMain main;
    private String type;

    public DataManagementAction(ChisioMain main) {
        super("Data Selection ...");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/data-selection.png"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        if (this.type == null) {
            Set<String> types = this.main.getLoadedExperimentTypes();
            if (types.isEmpty()) {
                MessageDialog.openError(this.main.getShell(), "Error!", "Load experiment data first.");
                return;
            }
            if (types.size() == 1) {
                this.type = types.iterator().next();
            } else {
                ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 200, "Experiment Type Selection Dialog", "Select experiment type", new ArrayList<String>(types), new ArrayList(), false, true, null);
                dialog.setMinValidSelect(1);
                Object selected = dialog.open();
                if (selected != null) {
                    this.type = selected.toString();
                }
                if (dialog.isCancelled()) {
                    this.type = null;
                }
            }
        }
        if (this.type != null) {
            ExperimentDataManagementDialog dialog = new ExperimentDataManagementDialog(this.main, this.main.getExperimentDataManager(this.type));
            dialog.open();
            this.type = null;
        }
    }
}

