/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.Level2Element;
import org.biopax.paxtools.model.level3.Level3Element;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.model.NodeModel;
import org.gvt.model.biopaxl3.Actor;
import org.gvt.model.biopaxl3.ChbComplex;
import org.gvt.model.biopaxl3.ChbConversion;
import org.gvt.model.biopaxl3.NonModulatedEffector;
import org.gvt.util.ID;

public class DebugButtonAction
extends Action {
    ChisioMain main;

    public DebugButtonAction(ChisioMain main) {
        super("Debug button");
        this.setToolTipText("Debug Button - You can run any\ncode after pressing this button.\nInsert your code in the class\nDebugButtonAction");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/bug.png"));
        this.main = main;
    }

    @Override
    public void run() {
        try {
            this.workOnSelected();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void workOnSelected() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        Iterator selectedObjects = ((IStructuredSelection)viewer.getSelection()).iterator();
        while (selectedObjects.hasNext()) {
            Object o = ((EditPart)selectedObjects.next()).getModel();
            if (o instanceof NodeModel) {
                NodeModel model = (NodeModel)o;
                if (model instanceof Actor) {
                    Actor actor = (Actor)model;
                    if (actor.getEntity().l3pe != null) {
                        System.out.println(actor.getEntity().l3pe.getDisplayName());
                        System.out.println("pe id = " + ID.get(actor.getEntity().l3pe));
                    }
                    if (actor.getEntity().l3er == null) continue;
                    System.out.println("er id = " + ID.get(actor.getEntity().l3er));
                    continue;
                }
                if (o instanceof ChbComplex) {
                    ChbComplex cmp = (ChbComplex)o;
                    System.out.println(cmp.getEntity().l3pe.getDisplayName());
                    System.out.println(ID.get(cmp.getComplex()));
                    continue;
                }
                if (!(o instanceof ChbConversion)) continue;
                ChbConversion cnv = (ChbConversion)o;
                System.out.println("conversion id = " + ID.get(cnv.getConversion()));
                continue;
            }
            if (!(o instanceof NonModulatedEffector)) continue;
            System.out.println("cont id = " + ID.get(((NonModulatedEffector)o).getControl()));
        }
    }

    private void clearLayoutInFiles() throws FileNotFoundException {
        SimpleIOHandler h = new SimpleIOHandler();
        File dir = new File("/home/ozgun/Projects/chibe/samples/level 2/");
        for (File file : dir.listFiles()) {
            if (file.getName().endsWith(".owl")) {
                // empty if block
            }
            Model model = h.convertFromOWL(new FileInputStream(file));
            for (BioPAXElement ele : model.getObjects()) {
                HashSet<String> remove = new HashSet<String>();
                if (ele instanceof Level2Element) {
                    for (String com : ((Level2Element)ele).getCOMMENT()) {
                        if (!com.contains("@Layout@")) continue;
                        remove.add(com);
                    }
                    for (String rem : remove) {
                        ((Level2Element)ele).removeCOMMENT(rem);
                    }
                    continue;
                }
                if (!(ele instanceof Level3Element)) continue;
                for (String com : ((Level3Element)ele).getComment()) {
                    if (!com.contains("@Layout@")) continue;
                    remove.add(com);
                }
                for (String rem : remove) {
                    ((Level3Element)ele).removeComment(rem);
                }
            }
            h.convertToOWL(model, new FileOutputStream(file));
        }
    }

    static class Waiter {
        Waiter() {
        }

        public static synchronized void pause(long time) {
            Waiter w = new Waiter();
            w.bekle(time);
        }

        private synchronized void bekle(long time) {
            try {
                this.wait(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

