/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import org.biopax.paxtools.model.Model;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.MessageBox;
import org.gvt.ChisioMain;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.util.PathwayHolder;

public class DeletePathwayAction
extends Action {
    private ChisioMain main;
    private boolean allOpenPathways;

    public DeletePathwayAction(ChisioMain main, boolean allOpenPathways) {
        super(allOpenPathways ? "Delete All Open Pathways" : "Delete Pathway");
        if (allOpenPathways) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-delete-all.png"));
        } else {
            this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/pathway-delete.png"));
        }
        this.setToolTipText(this.getText());
        this.main = main;
        this.allOpenPathways = allOpenPathways;
    }

    public DeletePathwayAction(ChisioMain main) {
        this(main, false);
    }

    @Override
    public void run() {
        CTabItem tab = this.main.getSelectedTab();
        if (tab != null) {
            BioPAXGraph graph;
            CompoundModel root = (CompoundModel)this.main.getTabToViewerMap().get(tab).getContents().getModel();
            if (root instanceof BioPAXGraph && (graph = (BioPAXGraph)root).getPathway() != null && graph.getPathway().hasEdge()) {
                MessageDialog.openError(this.main.getShell(), "Cannot delete pathway", "Pathway is either a participant of an interaction,\nor controller of, or controlled by a control.\nNot safe to delete.");
                return;
            }
            String s = this.allOpenPathways ? "all open pathways" : "the pathway";
            MessageBox box = new MessageBox(this.main.getShell(), 448);
            box.setText("Confirm");
            box.setMessage("Delete " + s + "?\nContents will not be deleted from the model!");
            int answer = box.open();
            if (answer == 64) {
                if (this.allOpenPathways) {
                    for (CTabItem tabItem : new ArrayList<CTabItem>(this.main.getTabToViewerMap().keySet())) {
                        this.deletePathway(tabItem);
                    }
                } else {
                    this.deletePathway(tab);
                }
            }
        }
    }

    private void deletePathway(CTabItem tab) {
        BioPAXGraph graph;
        ScrollingGraphicalViewer viewer = this.main.getTabToViewerMap().get(tab);
        this.main.closeTab(tab, false);
        CompoundModel root = (CompoundModel)viewer.getContents().getModel();
        if (root instanceof BioPAXGraph && (graph = (BioPAXGraph)root).isMechanistic()) {
            graph.forgetLayout();
            Model model = graph.getBiopaxModel();
            PathwayHolder p = graph.getPathway();
            p.removeFromModel(model);
            this.main.getAllPathwayNames().remove(p.getName());
        }
    }
}

