/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cbio.causality.util.Download;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;
import org.cbio.causality.util.FormatUtil;
import org.gvt.ChisioMain;
import org.gvt.action.FetchFromCBioPortalAction;
import org.gvt.action.HighlightWithRefAction;
import org.gvt.action.LoadTCGASpecificSIFAction;
import org.gvt.action.QueryPCAction;
import org.gvt.action.QueryPCGetAction;
import org.gvt.gui.GeneSetSelectionDialog;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.util.Conf;
import org.patika.mada.util.XRef;

public class EnrichedPathwaysAction
extends LoadTCGASpecificSIFAction {
    private static final String DEFAULT_PATHWAY_2_GENE_FILE_NAME = "pathway2gene.txt";

    public EnrichedPathwaysAction(ChisioMain main) {
        super("Find Enriched Pathways ...", main);
    }

    @Override
    public void run() {
        GeneSetSelectionDialog gssd = new GeneSetSelectionDialog(this.main.getShell());
        List<String> query = gssd.open();
        if (query == null || query.isEmpty()) {
            return;
        }
        Map<String, Pathway> pathwayMap = this.getPathways(query);
        HashSet<String> allSymbols = new HashSet<String>();
        for (Pathway pathway2 : pathwayMap.values()) {
            allSymbols.addAll(pathway2.genes);
        }
        int allSize = allSymbols.size();
        int querySize = query.size();
        HashMap<String, Double> pvals = new HashMap<String, Double>();
        for (Pathway pathway2 : pathwayMap.values()) {
            pathway2.assignPval(allSize, querySize);
            pvals.put(pathway2.id, pathway2.pval);
        }
        Map<String, Double> qVals = FDR.getQVals(pvals, null);
        for (String key : qVals.keySet()) {
            pathwayMap.get((Object)key).qval = FormatUtil.roundToSignificantDigits(qVals.get(key), 1);
        }
        ArrayList<Pathway> arrayList = new ArrayList<Pathway>(pathwayMap.values());
        Collections.sort(arrayList);
        List<SelectionItem> items = new ArrayList();
        for (Pathway p : arrayList) {
            if (p.hit.isEmpty() || !(p.pval < 0.5)) continue;
            items.add(new SelectionItem(p));
        }
        Collections.sort(items);
        items = items.subList(0, Math.min(100, items.size()));
        ArrayList selected = new ArrayList();
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 800, "Enriched pathways", "Please select pathway to view", items, selected, true, true, null);
        dialog.open();
        if (dialog.isCancelled() || selected.isEmpty()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> genes = new HashSet<String>();
        for (SelectionItem item : selected) {
            ids.add(item.pathway.id);
            genes.addAll(item.pathway.hit);
        }
        QueryPCGetAction qa = new QueryPCGetAction(this.main, false, QueryPCAction.QueryLocation.PC_MECH);
        qa.setIDs(ids);
        qa.setCreateNewPathwayForView(false);
        qa.run();
        HashSet<XRef> xrefs = new HashSet<XRef>();
        for (String gene : genes) {
            xrefs.add(new XRef("Name", gene));
        }
        HighlightWithRefAction ha = new HighlightWithRefAction(this.main, this.main.getPathwayGraph(), xrefs);
        ha.run();
        FetchFromCBioPortalAction fa = new FetchFromCBioPortalAction(this.main, "CURRENT_STUDY");
        fa.run();
    }

    private Map<String, Pathway> getPathways(Collection<String> query) {
        File rFile = new File(this.getPathwayFileLocation());
        if (!rFile.exists()) {
            this.downloadPathwayFile(rFile.getPath());
        }
        try {
            HashMap<String, Pathway> pathways = new HashMap<String, Pathway>();
            BufferedReader reader = new BufferedReader(new FileReader(rFile));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                Pathway p = new Pathway(token[0], token[1], Arrays.asList(token).subList(2, token.length), query);
                if (p.genes.size() > 1) {
                    pathways.put(p.id, p);
                }
                line = reader.readLine();
            }
            reader.close();
            return pathways;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getPathwayFileLocation() {
        String s = Conf.get("PATHWAY_2_GENE_FILE");
        if (s.equals("DEFAULT")) {
            return Conf.getPortalCacheDir() + DEFAULT_PATHWAY_2_GENE_FILE_NAME;
        }
        return s;
    }

    private boolean downloadPathwayFile(String saveLoc) {
        String url = Conf.get("PATHWAY_2_GENE_FILE_URL");
        return Download.downlaodTextFile(url, saveLoc);
    }

    class SelectionItem
    implements Comparable {
        Pathway pathway;

        SelectionItem(Pathway pathway2) {
            this.pathway = pathway2;
        }

        public String toString() {
            return this.pathway.name + " [" + FormatUtil.roundToSignificantDigits(this.pathway.pval, 2) + "] " + this.pathway.getHitGenes();
        }

        public int compareTo(Object o) {
            if (!(o instanceof SelectionItem)) {
                return 0;
            }
            return new Double(this.pathway.qval).compareTo(((SelectionItem)o).pathway.qval);
        }
    }

    class Pathway
    implements Comparable {
        String id;
        String name;
        List<String> genes;
        List<String> hit;
        double pval;
        double qval;

        Pathway(String id, String name, List<String> genes, Collection<String> query) {
            this.id = id;
            this.name = name;
            this.genes = genes;
            this.hit = new ArrayList<String>(genes);
            this.hit.retainAll(query);
            Collections.sort(this.hit);
        }

        String getHitGenes() {
            String k = this.hit.get(0);
            int i = 0;
            for (String s : this.hit) {
                if (i++ == 0) continue;
                k = k + " - " + s;
            }
            return k;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Pathway)) {
                return 0;
            }
            return new Double(this.qval).compareTo(((Pathway)o).qval);
        }

        public void assignPval(int totalSymbolSize, int querySize) {
            this.pval = FishersExactTest.calcEnrichmentPval(totalSymbolSize, querySize, this.genes.size(), this.hit.size());
        }
    }
}

