/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cbio.causality.util.Download;
import org.cbio.causality.util.FDR;
import org.cbio.causality.util.FishersExactTest;
import org.cbio.causality.util.FormatUtil;
import org.gvt.ChisioMain;
import org.gvt.action.FetchFromCBioPortalAction;
import org.gvt.action.HighlightWithRefAction;
import org.gvt.action.LoadTCGASpecificSIFAction;
import org.gvt.action.QueryPCAction;
import org.gvt.action.QueryPCGetAction;
import org.gvt.gui.GeneSetSelectionDialog;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.util.Conf;
import org.patika.mada.util.XRef;

public class EnrichedReactionsAction
extends LoadTCGASpecificSIFAction {
    private static final String DEFAULT_REACTION_2_GENE_FILE_NAME = "reaction2gene.txt";

    public EnrichedReactionsAction(ChisioMain main) {
        super("Find Enriched Reactions ...", main);
    }

    @Override
    public void run() {
        GeneSetSelectionDialog erd = new GeneSetSelectionDialog(this.main.getShell());
        List<String> query = erd.open();
        if (query == null || query.isEmpty()) {
            return;
        }
        Map<String, Reaction> reactions = this.getReactions(query);
        HashSet<String> allSymbols = new HashSet<String>();
        for (Reaction reaction : reactions.values()) {
            allSymbols.addAll(reaction.genes);
        }
        int allSize = allSymbols.size();
        int querySize = query.size();
        HashMap<String, Double> pvals = new HashMap<String, Double>();
        for (Reaction reaction : reactions.values()) {
            reaction.assignPval(allSize, querySize);
            pvals.put(reaction.id, reaction.pval);
        }
        Map<String, Double> qVals = FDR.getQVals(pvals, null);
        for (String string : qVals.keySet()) {
            reactions.get((Object)string).qval = FormatUtil.roundToSignificantDigits(qVals.get(string), 1);
        }
        HashMap hashMap = new HashMap();
        for (Reaction reac : reactions.values()) {
            if (reac.hit.isEmpty()) continue;
            String key = reac.getKey();
            if (!hashMap.containsKey(key)) {
                hashMap.put(key, new ArrayList());
            }
            ((List)hashMap.get(key)).add(reac);
        }
        for (Object list : hashMap.values()) {
            Collections.sort(list);
        }
        ArrayList<SelectionItem> arrayList = new ArrayList<SelectionItem>();
        for (List list : hashMap.values()) {
            arrayList.add(new SelectionItem((Reaction)list.get(0)));
        }
        Collections.sort(arrayList);
        List list = arrayList.subList(0, Math.min(100, arrayList.size()));
        ArrayList selected = new ArrayList();
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 400, "Hot reactions", "Plase select reaction to view", list, selected, true, true, null);
        dialog.open();
        if (dialog.isCancelled() || selected.isEmpty()) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> genes = new HashSet<String>();
        for (SelectionItem item : selected) {
            for (Object reac : (List)hashMap.get(item.reac.getKey())) {
                Collections.addAll(ids, ((Reaction)reac).ids);
                genes.addAll(((Reaction)reac).hit);
            }
        }
        String title = "Enriched reactions";
        QueryPCGetAction qa = new QueryPCGetAction(this.main, false, QueryPCAction.QueryLocation.PC_MECH);
        qa.setIDs(ids);
        qa.setNewPathwayName(title);
        qa.run();
        HashSet<XRef> xrefs = new HashSet<XRef>();
        for (String gene : genes) {
            xrefs.add(new XRef("Name", gene));
        }
        HighlightWithRefAction ha = new HighlightWithRefAction(this.main, this.main.getPathwayGraph(), xrefs);
        ha.run();
        FetchFromCBioPortalAction fa = new FetchFromCBioPortalAction(this.main, "CURRENT_STUDY");
        fa.run();
    }

    private Map<String, Reaction> getReactions(Collection<String> query) {
        File rFile = new File(this.getReactionFileLocation());
        if (!rFile.exists()) {
            this.downloadReactionFile(rFile.getPath());
        }
        try {
            HashMap<String, Reaction> reactions = new HashMap<String, Reaction>();
            BufferedReader reader = new BufferedReader(new FileReader(rFile));
            String line = reader.readLine();
            while (line != null) {
                String[] token = line.split("\t");
                Reaction r = new Reaction(token[0], Arrays.asList(token).subList(1, token.length), query);
                reactions.put(r.id, r);
                line = reader.readLine();
            }
            reader.close();
            return reactions;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getReactionFileLocation() {
        String s = Conf.get("REACTION_2_GENE_FILE");
        if (s.equals("DEFAULT")) {
            return Conf.getPortalCacheDir() + DEFAULT_REACTION_2_GENE_FILE_NAME;
        }
        return s;
    }

    private boolean downloadReactionFile(String saveLoc) {
        String url = Conf.get("REACTION_2_GENE_FILE_URL");
        return Download.downlaodTextFile(url, saveLoc);
    }

    class SelectionItem
    implements Comparable {
        Reaction reac;

        SelectionItem(Reaction reac) {
            this.reac = reac;
        }

        public String toString() {
            return this.reac.getKey() + " [" + FormatUtil.roundToSignificantDigits(this.reac.pval, 2) + "]";
        }

        public int compareTo(Object o) {
            if (!(o instanceof SelectionItem)) {
                return 0;
            }
            return new Double(this.reac.qval).compareTo(((SelectionItem)o).reac.qval);
        }
    }

    class Reaction
    implements Comparable {
        String id;
        String[] ids;
        List<String> genes;
        List<String> hit;
        double pval;
        double qval;

        Reaction(String id, List<String> genes, Collection<String> query) {
            this.ids = id.split(" ");
            this.id = this.ids[0];
            this.genes = genes;
            this.hit = new ArrayList<String>(genes);
            this.hit.retainAll(query);
            Collections.sort(this.hit);
        }

        String getKey() {
            String k = this.hit.get(0);
            int i = 0;
            for (String s : this.hit) {
                if (i++ == 0) continue;
                k = k + " - " + s;
            }
            return k;
        }

        public int compareTo(Object o) {
            if (!(o instanceof Reaction)) {
                return 0;
            }
            return new Double(this.qval).compareTo(((Reaction)o).qval);
        }

        public void assignPval(int totalSymbolSize, int querySize) {
            this.pval = FishersExactTest.calcEnrichmentPval(totalSymbolSize, querySize, this.genes.size(), this.hit.size());
        }
    }
}

