/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.gvt.action.FileAccessorAction;

public class FileChooser {
    FileAccessorAction action;
    boolean forSave;

    public FileChooser(FileAccessorAction action, boolean forSave) {
        this.action = action;
        this.forSave = forSave;
    }

    public FileChooser(FileAccessorAction action) {
        this(action, false);
    }

    public String choose(String key) {
        File file;
        FileDialog fileChooser = new FileDialog(this.action.getShell(), this.forSave ? 8192 : 4096);
        fileChooser.setFilterExtensions(this.action.getFilterExtensions(key));
        fileChooser.setFilterNames(this.action.getFilterNames(key));
        if (this.action.getLastPath(key) != null) {
            fileChooser.setFilterPath(this.action.getLastPath(key));
        }
        if (this.action.getCurrentFilename() != null) {
            fileChooser.setFileName(this.action.getCurrentFilename());
        }
        String f = fileChooser.open();
        String x = null;
        if (f != null) {
            if (f.contains("/")) {
                x = f.substring(0, f.lastIndexOf("/"));
            } else if (f.contains("\\")) {
                x = f.substring(0, f.lastIndexOf("\\"));
            }
        }
        if (x != null) {
            this.action.setLastPath(x, key);
        }
        if (f != null && this.forSave && (file = new File(f)).exists()) {
            MessageBox mb = new MessageBox(this.action.getShell(), 200);
            mb.setMessage(f + " already exists. Do you want to replace it?");
            mb.setText("Confirm Replace File");
            if (mb.open() != 64) {
                f = new FileChooser(this.action, this.forSave).choose(key);
            }
        }
        return f;
    }
}

