/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.gui.StringInputDialog;
import org.gvt.model.CompoundModel;
import org.gvt.model.NodeModel;

public class HighlightByNameAction
extends Action {
    ChisioMain main;
    String name;

    public HighlightByNameAction(ChisioMain main) {
        super("Highlight By Name ...");
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        if (this.name == null) {
            StringInputDialog dialog = new StringInputDialog(this.main.getShell(), "Highlight By Name", "Enter keyword for searching entities", null);
            this.name = dialog.open();
        }
        if (this.name != null && this.name.trim().length() > 0) {
            this.name = this.name.toLowerCase().trim();
            boolean highlighted = this.highlight(this.name.split("\\s+"));
            if (!highlighted) {
                MessageDialog.openInformation(this.main.getShell(), "Not Found.", "\"" + this.name + "\" is not found");
            }
        }
        this.name = null;
    }

    protected boolean highlight(String ... names) {
        CompoundModel root = (CompoundModel)((ChsRootEditPart)this.main.getViewer().getRootEditPart().getChildren().get(0)).getModel();
        Iterator nodeIter = root.getNodes().iterator();
        boolean highlighted = false;
        while (nodeIter.hasNext()) {
            NodeModel node = (NodeModel)nodeIter.next();
            for (String name : names) {
                if (name.length() < 2 || !node.getText().toLowerCase().contains(name) && (node.getTooltipText() == null || !node.getTooltipText().toLowerCase().contains(name))) continue;
                node.setHighlightColor(ChisioMain.higlightColor);
                node.setHighlight(true);
                highlighted = true;
            }
        }
        return highlighted;
    }
}

