/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Color;
import org.gvt.ChisioMain;
import org.gvt.action.RemoveColorsAction;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.NodeModel;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.sifl3.SIFGraph;
import org.gvt.util.CancerGenes;

public class HighlightCancerGenesActions
extends Action {
    ChisioMain main;

    public HighlightCancerGenesActions(ChisioMain main) {
        super("Highlight cancer genes (COSMIC + OncoKB)");
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        BioPAXGraph graph = this.main.getPathwayGraph();
        if (!(graph instanceof BasicSIFGraph) && !(graph instanceof SIFGraph)) {
            return;
        }
        new RemoveColorsAction(this.main).run();
        int cnt = 0;
        for (Object o : graph.getNodes()) {
            NodeModel node;
            String name;
            if (!(o instanceof NodeModel) || !CancerGenes.isCancerGene(name = (node = (NodeModel)o).getText())) continue;
            node.setColor(new Color(null, 255, 255, 155));
            ++cnt;
        }
        System.out.println("highlighted = " + cnt);
    }
}

