/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.NodeModel;

public class HighlightUsingFileAction
extends ChiBEAction {
    String filename;

    public HighlightUsingFileAction(ChisioMain main) {
        super("Highlight Using File ...", null, main);
        this.addFilterExtension("FILE_KEY", new String[]{"*.highlight"});
        this.addFilterName("FILE_KEY", new String[]{"Highlight File (*.highlight)"});
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        if (this.filename == null) {
            this.filename = new FileChooser(this).choose("FILE_KEY");
        }
        if (this.filename == null) {
            return;
        }
        HashSet<String> nodeNames = new HashSet<String>();
        HashSet<String> edgeNames = new HashSet<String>();
        this.loadElementsToHighlight(this.filename, nodeNames, edgeNames);
        int highlightedNodes = this.highlightNodes(nodeNames);
        int highlightedEdges = this.highlightEdges(edgeNames);
        if (highlightedNodes + highlightedEdges == 0) {
            MessageDialog.openInformation(this.main.getShell(), "Information:", "There is nothing to highlight.");
        } else if (highlightedEdges == 0) {
            MessageDialog.openInformation(this.main.getShell(), "Information:", highlightedNodes + " nodes are highlighted.");
        } else if (highlightedNodes == 0) {
            MessageDialog.openInformation(this.main.getShell(), "Information:", highlightedEdges + " edges are highlighted.");
        } else {
            MessageDialog.openInformation(this.main.getShell(), "Information:", highlightedNodes + " nodes and " + highlightedEdges + " edges are highlighted.");
        }
        this.filename = null;
    }

    protected int highlightNodes(Set<String> names) {
        CompoundModel root = (CompoundModel)((ChsRootEditPart)this.main.getViewer().getRootEditPart().getChildren().get(0)).getModel();
        Iterator nodeIter = root.getNodes().iterator();
        int highlighted = 0;
        while (nodeIter.hasNext()) {
            NodeModel node = (NodeModel)nodeIter.next();
            if (!names.contains(node.getText())) continue;
            node.setHighlightColor(ChisioMain.higlightColor);
            node.setHighlight(true);
            ++highlighted;
        }
        return highlighted;
    }

    protected int highlightEdges(Set<String> names) {
        CompoundModel root = (CompoundModel)((ChsRootEditPart)this.main.getViewer().getRootEditPart().getChildren().get(0)).getModel();
        Iterator nodeIter = root.getEdges().iterator();
        int highlighted = 0;
        while (nodeIter.hasNext()) {
            EdgeModel edge = (EdgeModel)nodeIter.next();
            if (!names.contains(edge.getSource().getText() + "\t" + edge.getTarget().getText())) continue;
            edge.setHighlightColor(ChisioMain.higlightColor);
            edge.setHighlight(true);
            ++highlighted;
        }
        return highlighted;
    }

    protected void loadElementsToHighlight(String filename, Set<String> nodeNames, Set<String> edgeNames) {
        try {
            Scanner sc = new Scanner(new File(filename));
            while (sc.hasNextLine()) {
                String[] token = sc.nextLine().split("\t");
                if (token.length < 2) continue;
                if (token[0].equals("node")) {
                    nodeNames.add(token[1]);
                    continue;
                }
                if (!token[0].equals("edge")) continue;
                edgeNames.add(token[1] + "\t" + token[2]);
            }
            sc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

