/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.RemoveHighlightsAction;
import org.gvt.gui.HighlightWithDataValuesDialog;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.IBioPAXNode;
import org.patika.mada.util.Representable;

public class HighlightWithDataValuesAction
extends Action {
    ChisioMain main;
    private BioPAXGraph graph;
    private double preMin = -1.7976931348623157E308;
    private double preMax = Double.MAX_VALUE;

    public HighlightWithDataValuesAction(ChisioMain main) {
        super("Highlight With Data Values ...");
        this.main = main;
    }

    @Override
    public void run() {
        HighlightWithDataValuesDialog dialog;
        boolean okPressed;
        this.graph = this.main.getPathwayGraph();
        if (this.graph == null) {
            return;
        }
        String type = this.graph.getLastAppliedColoring();
        if (type == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load data first.");
            return;
        }
        RemoveHighlightsAction rha = new RemoveHighlightsAction(this.main);
        rha.run();
        HashMap<IBioPAXNode, Double> valueMap = new HashMap<IBioPAXNode, Double>();
        for (Object obj : this.graph.getNodes()) {
            String toolTip;
            IBioPAXNode node;
            Representable data;
            if (!(obj instanceof IBioPAXNode) || (data = (node = (IBioPAXNode)obj).getRepresentableData(type)) == null || (toolTip = data.getToolTipText()) == null || toolTip.equals("No Data")) continue;
            Double value = Double.parseDouble(toolTip);
            valueMap.put(node, value);
        }
        if (valueMap.isEmpty()) {
            MessageDialog.openWarning(this.main.getShell(), "No Data!", "There is not any node associated with experiment data. \nPlease load another data.");
            return;
        }
        boolean newData = true;
        double maxValue = (Double)Collections.max(valueMap.values());
        double minValue = (Double)Collections.min(valueMap.values());
        if (maxValue == this.preMax && minValue == this.preMin) {
            newData = false;
        }
        if (!(okPressed = (dialog = new HighlightWithDataValuesDialog(this.main.getShell(), maxValue, minValue, newData)).open())) {
            return;
        }
        double[] results = dialog.getResultArray();
        for (IBioPAXNode node : valueMap.keySet()) {
            if (dialog.getRangeType() && (Double)valueMap.get(node) >= results[0] && (Double)valueMap.get(node) <= results[1]) {
                node.setHighlight(true);
                continue;
            }
            if (dialog.getRangeType() || !((Double)valueMap.get(node) < results[0]) && !((Double)valueMap.get(node) > results[1])) continue;
            node.setHighlight(true);
        }
        this.preMin = minValue;
        this.preMax = maxValue;
    }
}

