/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.inspector.CompoundInspector;
import org.gvt.inspector.EdgeInspector;
import org.gvt.inspector.GraphInspector;
import org.gvt.inspector.NodeInspector;
import org.gvt.model.CompoundModel;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;

public class InspectorAction
extends Action {
    ChisioMain main;

    public InspectorAction(ChisioMain main, boolean isGraph) {
        this.setText(isGraph ? "Properties ..." : "Object Properties ...");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/inspector.png"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        if (this.main.getViewer() == null) {
            return;
        }
        Object obj = ((IStructuredSelection)this.main.getViewer().getSelection()).getFirstElement();
        if (!(obj instanceof ScalableRootEditPart)) {
            GraphObject model = (GraphObject)((AbstractEditPart)obj).getModel();
            if (model instanceof EdgeModel) {
                EdgeInspector.getInstance(model, "Edge", this.main);
            } else if (model instanceof CompoundModel) {
                if (!((CompoundModel)model).isRoot()) {
                    CompoundInspector.getInstance(model, "Compound", this.main);
                }
            } else if (model instanceof NodeModel) {
                NodeInspector.getInstance(model, "Node", this.main);
            }
        } else {
            ChsRootEditPart edit = (ChsRootEditPart)((ScalableRootEditPart)obj).getChildren().get(0);
            GraphInspector.getInstance((GraphObject)edit.getModel(), "Graph", this.main);
        }
    }
}

