/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.Model;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.action.OpenPathwaysAction;
import org.gvt.action.SaveBioPAXFileAction;
import org.gvt.gui.StringInputDialog;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.PathwayHolder;

public class LoadBioPaxModelAction
extends ChiBEAction {
    protected String filename;
    private String newPathwayName;
    private String openPathwayName;
    private String lastPathwayName;
    private boolean fromURL;
    protected Model model;
    private boolean openPathways;
    public static final String[] FILTER_EXTENSIONS = new String[]{"*.owl"};

    public LoadBioPaxModelAction(ChisioMain chisio) {
        super("Load ...", "icon/open.png", chisio);
        this.addLastLocation("FILE_KEY", "samples/");
        this.addFilterName("FILE_KEY", new String[]{"BioPAX (*.owl)"});
        this.addFilterExtension("FILE_KEY", FILTER_EXTENSIONS);
        this.openPathways = true;
        this.fromURL = false;
    }

    public LoadBioPaxModelAction(ChisioMain main, boolean fromURL) {
        this(main);
        this.fromURL = fromURL;
        if (fromURL) {
            this.setText("Load from URL ...");
            this.setToolTipText(this.getText());
        }
    }

    public void setOpenPathways(boolean openPathways) {
        this.openPathways = openPathways;
    }

    public void setOpenPathwayName(String openPathwayName) {
        this.openPathwayName = openPathwayName;
    }

    public void setNewPathwayName(String newPathwayName) {
        this.newPathwayName = newPathwayName;
    }

    public String getNewPathwayName() {
        return this.newPathwayName;
    }

    public String getLastPathwayName() {
        return this.lastPathwayName;
    }

    public void setFromURL(boolean fromURL) {
        this.fromURL = fromURL;
    }

    public LoadBioPaxModelAction(ChisioMain chisio, String filename) {
        this(chisio);
        this.filename = filename;
    }

    public LoadBioPaxModelAction(ChisioMain chisio, Model model) {
        this(chisio);
        this.model = model;
    }

    public static boolean saveChangesBeforeDiscard(ChisioMain main) {
        if (main.isDirty() && main.getBioPAXModel() != null) {
            MessageBox messageBox = new MessageBox(main.getShell(), 456);
            messageBox.setMessage("Would you like to save the changes?");
            messageBox.setText("Chisio BioPAX Editor");
            int answer = messageBox.open();
            if (answer == 64) {
                SaveBioPAXFileAction save = new SaveBioPAXFileAction(main);
                save.run();
                return save.isSaved();
            }
            return answer == 128;
        }
        return true;
    }

    public String openURLGetter() {
        StringInputDialog d = new StringInputDialog(this.main.getShell(), "URL", "Please enter URL of the owl file", null);
        return d.open();
    }

    @Override
    public void run() {
        if (LoadBioPaxModelAction.saveChangesBeforeDiscard(this.main)) {
            if (this.filename == null && this.model == null) {
                String string = this.filename = this.fromURL ? this.openURLGetter() : new FileChooser(this).choose("FILE_KEY");
                if (this.filename == null || this.filename.isEmpty()) {
                    return;
                }
            }
            try {
                this.main.lockWithMessage("Loading BioPAX model ...");
                if (this.model == null) {
                    SimpleIOHandler reader = new SimpleIOHandler();
                    if (this.fromURL) {
                        try {
                            this.model = reader.convertFromOWL(new URL(this.filename).openStream());
                        }
                        catch (IOException e) {
                            MessageDialog.openError(this.main.getShell(), "URL error", "Cannot get data from the provided URL:\n" + this.filename);
                            e.printStackTrace();
                        }
                    } else {
                        this.model = reader.convertFromOWL(new FileInputStream(this.filename));
                    }
                }
                if (this.model != null) {
                    if (BioPAXUtil.numberOfUnemptyPathways(this.model) == 0 || this.newPathwayName != null) {
                        String name;
                        String string = name = this.newPathwayName == null ? this.filename : this.newPathwayName;
                        if (name != null) {
                            if (name.contains("\\")) {
                                name = name.substring(name.lastIndexOf("\\") + 1);
                            } else if (name.contains("/")) {
                                name = name.substring(name.lastIndexOf("/") + 1);
                            }
                            if (name.contains(".")) {
                                name = name.substring(0, name.lastIndexOf("."));
                            }
                        } else {
                            name = "Auto-created Pathway";
                        }
                        PathwayHolder ph = BioPAXUtil.createGlobalPathway(this.model, name);
                        this.newPathwayName = ph.getName();
                    }
                    if (this.main.getBioPAXModel() != null) {
                        this.main.closeAllTabs(false);
                    }
                    this.main.setBioPAXModel(this.model);
                    if (!this.fromURL) {
                        this.main.setOwlFileName(this.filename);
                    }
                    if (this.openPathways) {
                        this.main.unlock();
                        List<String> names = BioPAXUtil.namesOfUnemptyPathways(this.model);
                        List<String> autoOpen = null;
                        if (names.size() == 1) {
                            autoOpen = Arrays.asList(names.get(0));
                        } else if (this.newPathwayName != null) {
                            autoOpen = Arrays.asList(this.newPathwayName);
                        } else if (this.openPathwayName != null) {
                            autoOpen = Arrays.asList(this.openPathwayName);
                        }
                        new OpenPathwaysAction(this.main, autoOpen).run();
                    }
                } else {
                    MessageDialog.openError(this.main.getShell(), "Error", "Cannot load file.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.filename = null;
                this.model = null;
                this.lastPathwayName = this.newPathwayName;
                this.newPathwayName = null;
                this.main.unlock();
            }
        }
    }

    public static boolean hasValidExtension(String path) {
        for (String extension : FILTER_EXTENSIONS) {
            if (!path.substring(path.lastIndexOf(".")).equalsIgnoreCase(extension.substring(1))) continue;
            return true;
        }
        return false;
    }
}

