/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.List;
import org.cbio.causality.network.PhosphoSitePlus;
import org.cbio.causality.rppa.RPPAData;
import org.cbio.causality.rppa.RPPANetworkMapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.WizardDialog;
import org.gvt.ChisioMain;
import org.gvt.action.LoadSIFFileAction;
import org.gvt.gui.RPPAWizard;

public class LoadRPPAAction
extends Action {
    ChisioMain main;

    public LoadRPPAAction(ChisioMain main) {
        super("Load RPPA Data ...");
        this.main = main;
    }

    @Override
    public void run() {
        try {
            RPPAWizard wizard = new RPPAWizard();
            WizardDialog dialog = new WizardDialog(this.main.getShell(), wizard);
            if (dialog.open() == 1) {
                return;
            }
            List<RPPAData> datas = wizard.readData();
            PhosphoSitePlus.fillInMissingEffect(datas, 0);
            RPPANetworkMapper.getDownstreamActivitySupportCounts(datas, RPPANetworkMapper.GraphType.COMPATIBLE_WITH_SITE_MATCH);
            double threshold = wizard.threshold;
            if (wizard.comparisonType == RPPAWizard.ComparisonType.TTEST || wizard.valueMetric == RPPAWizard.ValueMetric.PVAL) {
                threshold = -Math.log(threshold) / Math.log(2.0);
            }
            if (wizard.centricity == RPPAWizard.Centricity.GENE_CENTRIC) {
                RPPANetworkMapper.writeGraph(datas, threshold, wizard.getSIFFilename(), wizard.networkType.type, wizard.filterToGenes);
            } else {
                RPPANetworkMapper.writeGraphAntibodyCentric(datas, threshold, wizard.getSIFFilename(), wizard.networkType.type, wizard.filterToGenes);
            }
            LoadSIFFileAction action = new LoadSIFFileAction(this.main, wizard.getSIFFilename());
            action.run();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

