/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.FileChooser;
import org.gvt.action.LoadSIFLayoutAction;
import org.gvt.action.ShowFormatSeriesAction;
import org.gvt.action.ZoomAction;
import org.gvt.model.CompoundModel;
import org.gvt.util.CustomReader;
import org.gvt.util.SIFReader;

public class LoadSIFFileAction
extends ChiBEAction {
    String filename;
    boolean runLayout = true;
    public static final String[] FILTER_EXTENSIONS = new String[]{"*.sif", "*.cus"};

    public LoadSIFFileAction(ChisioMain chisio) {
        super("Load SIF File ...", "icon/open.png", chisio);
        this.addFilterExtension("FILE_KEY", FILTER_EXTENSIONS);
        this.addFilterName("FILE_KEY", new String[]{"Simple Interaction Format (*.sif)", "Custom Graph (*.cus)"});
        this.addLastLocation("FILE_KEY", "samples/");
    }

    public LoadSIFFileAction(ChisioMain chisio, String filename, boolean runLayout) {
        this(chisio);
        this.filename = filename;
        this.runLayout = runLayout;
    }

    public LoadSIFFileAction(ChisioMain chisio, String filename) {
        this(chisio, filename, true);
    }

    @Override
    public void run() {
        CompoundModel root;
        Object reader;
        File file;
        if (this.filename == null) {
            this.filename = new FileChooser(this).choose("FILE_KEY");
            if (this.filename == null) {
                return;
            }
        }
        if (this.main.getViewer() != null) {
            this.main.getHighlightLayer().removeAll();
            this.main.getHighlightLayer().highlighted.clear();
        }
        if ((file = new File(this.filename)).getName().endsWith(".cus")) {
            reader = new CustomReader();
            root = ((CustomReader)reader).readFile(file);
        } else {
            reader = new SIFReader();
            root = ((SIFReader)reader).readXMLFile(file);
        }
        if (root != null) {
            String series;
            this.main.createNewTab(root);
            String layoutFile = null;
            if (this.filename.endsWith(".sif") && !new File(layoutFile = this.filename.substring(0, this.filename.lastIndexOf(".")) + ".layout").exists()) {
                layoutFile = null;
            }
            if (layoutFile == null) {
                if (this.runLayout) {
                    new CoSELayoutAction(this.main).run();
                } else {
                    new ZoomAction(this.main, 0, null).run();
                }
            }
            this.main.setOwlFileName(this.filename);
            if (layoutFile != null) {
                LoadSIFLayoutAction action = new LoadSIFLayoutAction(this.main);
                action.setLayoutFilename(layoutFile);
                action.run();
                new ZoomAction(this.main, 100, null).run();
            }
            if (this.filename.endsWith(".sif") && new File(series = this.filename.substring(0, this.filename.lastIndexOf(".")) + ".formatseries").exists()) {
                ShowFormatSeriesAction action = new ShowFormatSeriesAction(this.main);
                action.setFormatFilename(series);
                action.run();
            }
        }
        this.filename = null;
    }

    public static boolean hasValidExtension(String path) {
        for (String extension : FILTER_EXTENSIONS) {
            if (!path.substring(path.lastIndexOf(".")).equalsIgnoreCase(extension.substring(1))) continue;
            return true;
        }
        return false;
    }
}

