/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.draw2d.geometry.Point;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.EdgeFixLayoutAction;
import org.gvt.action.FileChooser;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.sifl3.SIFGraph;

public class LoadSIFLayoutAction
extends ChiBEAction {
    private String layoutFilename;
    private BioPAXGraph graph;

    public LoadSIFLayoutAction(ChisioMain main) {
        super("Load Layout...", null, main);
        this.addFilterExtension("FILE_KEY", new String[]{"*.layout"});
        this.addFilterName("FILE_KEY", new String[]{"SIF Layout (*.layout)"});
    }

    public void setLayoutFilename(String layoutFilename) {
        this.layoutFilename = layoutFilename;
    }

    public void setGraph(BioPAXGraph graph) {
        this.graph = graph;
    }

    @Override
    public void run() {
        if (this.graph == null) {
            this.graph = this.main.getPathwayGraph();
        }
        if (!(this.graph instanceof BasicSIFGraph) && !(this.graph instanceof SIFGraph)) {
            return;
        }
        if (this.layoutFilename == null) {
            this.layoutFilename = new FileChooser(this).choose("FILE_KEY");
        }
        if (this.layoutFilename == null) {
            return;
        }
        Map<String, Point> map = this.loadLayout(this.layoutFilename);
        if (this.graph instanceof SIFGraph) {
            ((SIFGraph)this.graph).loadLayout(map);
        } else if (this.graph instanceof BasicSIFGraph) {
            ((BasicSIFGraph)this.graph).loadLayout(map);
        }
        EdgeFixLayoutAction action = new EdgeFixLayoutAction(this.main);
        action.run();
        this.graph = null;
        this.layoutFilename = null;
    }

    private Map<String, Point> loadLayout(String filename) {
        try {
            HashMap<String, Point> map = new HashMap<String, Point>();
            Scanner sc = new Scanner(new File(filename));
            while (sc.hasNextLine()) {
                String[] token = sc.nextLine().split("\t");
                if (token.length < 3) continue;
                map.put(token[0], new Point(Integer.valueOf(token[1]), Integer.valueOf(token[2])));
            }
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

