/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.AbstractLocalQueryAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.GoIQueryParamDialog;
import org.gvt.gui.GoIQueryParamWithEntitiesDialog;
import org.gvt.util.BioPAXUtil;
import org.gvt.util.EntityHolder;
import org.gvt.util.QueryOptionsPack;

public class LocalGoIQueryAction
extends AbstractLocalQueryAction {
    QueryOptionsPack options;
    private boolean useSelection;

    public LocalGoIQueryAction(ChisioMain main, boolean useSelection) {
        super(main, "Paths Between ...");
        this.setToolTipText(this.getText());
        this.options = new QueryOptionsPack();
        this.main = main;
        this.useSelection = useSelection;
    }

    @Override
    public void run() {
        this.LocalGoI();
    }

    public void LocalGoI() {
        Set<BioPAXElement> source;
        AbstractQueryParamDialog dialog;
        if (this.main.getBioPAXModel() == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        if (this.useSelection) {
            if (this.main.getPathwayGraph() == null) {
                MessageDialog.openError(this.main.getShell(), "Error!", "This feature works only for BioPAX graphs");
            }
            dialog = new GoIQueryParamDialog(this.main);
            this.options = dialog.open(this.options);
            if (this.options.isCancel()) {
                return;
            }
            this.options.setCancel(true);
            source = this.main.getSelectedBioPAXElements();
        } else {
            dialog = new GoIQueryParamWithEntitiesDialog(this.main, BioPAXUtil.getEntities(this.main.getBioPAXModel()));
            this.options = dialog.open(this.options);
            if (this.options.isCancel()) {
                return;
            }
            this.options.setCancel(true);
            List<EntityHolder> addedEntities = dialog.getAddedSourceEntities();
            source = BioPAXUtil.getContent(addedEntities);
        }
        Set<BioPAXElement> result = QueryExecuter.runPathsBetween(source, this.main.getBioPAXModel(), this.options.getLengthLimit(), new Filter[0]);
        this.viewAndHighlightResult(result, this.options.isCurrentView(), "Query Result");
    }
}

