/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.Model;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.CompoundModel;
import org.gvt.util.PathwayHolder;
import org.patika.mada.algorithm.LocalPathIterationQuery;
import org.patika.mada.algorithm.LocalPoIQuery;
import org.patika.mada.graph.Graph;
import org.patika.mada.graph.GraphObject;
import org.patika.mada.graph.Node;

public class LocalPathIterationQueryAction
extends Action {
    ChisioMain main;

    public LocalPathIterationQueryAction(ChisioMain main) {
        super("Path Iteration ...");
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        this.LocalPathIteration();
    }

    public void LocalPathIteration() {
        Model owlModel = this.main.getBioPAXModel();
        if (owlModel == null) {
            MessageDialog.openError(this.main.getShell(), "Error!", "Load or query a BioPAX model first!");
            return;
        }
        BioPAXGraph rootGraph = BioPAXGraph.newInstance(this.main.getBioPAXModel(), null);
        LocalPathIterationQuery lpi = new LocalPathIterationQuery(rootGraph);
        Set<LocalPathIterationQuery.NodePair> result = lpi.run();
        Object[] resultArray = new LocalPathIterationQuery.NodePair[result.size()];
        result.toArray(resultArray);
        Arrays.sort(resultArray);
        ArrayList<Object> realResult = new ArrayList<Object>();
        int max = 0;
        for (Object nodePair : resultArray) {
            if (((LocalPathIterationQuery.NodePair)nodePair).getCurrentShortestPath() <= max) continue;
            max = ((LocalPathIterationQuery.NodePair)nodePair).getCurrentShortestPath();
        }
        int i = resultArray.length - 1;
        while (((LocalPathIterationQuery.NodePair)resultArray[i]).getCurrentShortestPath() == max) {
            realResult.add(resultArray[i]);
            --i;
        }
        int j = realResult.size() + 1;
        while (realResult.size() < 10) {
            realResult.add(resultArray[resultArray.length - j]);
            ++j;
        }
        ArrayList<String> stringResult = new ArrayList<String>();
        HashMap<String, LocalPathIterationQuery.NodePair> nodeToString = new HashMap<String, LocalPathIterationQuery.NodePair>();
        for (LocalPathIterationQuery.NodePair nodePair : realResult) {
            String key = nodePair.toString();
            if (stringResult.contains(key)) continue;
            stringResult.add(key);
            nodeToString.put(key, nodePair);
        }
        ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 300, "Path Selection Dialog", "Select one of the longest paths to visualize", stringResult, new ArrayList(), false, true, null);
        dialog.setDoSort(false);
        dialog.open();
        if (dialog.isCancelled()) {
            return;
        }
        List list = dialog.getSelectedItems();
        LocalPathIterationQuery.NodePair selectedNodePair = (LocalPathIterationQuery.NodePair)nodeToString.get(list.get(0));
        HashSet<Node> sourceSet = new HashSet<Node>();
        sourceSet.addAll(rootGraph.getRelatedStates(selectedNodePair.getNodeA()));
        HashSet<Node> targetSet = new HashSet<Node>();
        targetSet.addAll(rootGraph.getRelatedStates(selectedNodePair.getNodeB()));
        LocalPoIQuery poi = new LocalPoIQuery(sourceSet, targetSet, false, 0, false);
        Set<GraphObject> resultSet = poi.run();
        if (resultSet.size() == 0) {
            MessageDialog.openWarning(this.main.getShell(), "No result!", "No path can be found with specified parameters");
        } else {
            Graph pathwayGraph = rootGraph.excise(resultSet);
            ((BioPAXGraph)pathwayGraph).setName("Path Iteration");
            PathwayHolder h = new PathwayHolder(((BioPAXGraph)pathwayGraph).getBiopaxModel(), ((BioPAXGraph)pathwayGraph).getName());
            ((BioPAXGraph)pathwayGraph).setPathway(h);
            ((BioPAXGraph)pathwayGraph).registerContentsToPathway();
            this.main.createNewTab((CompoundModel)((Object)pathwayGraph));
            new CoSELayoutAction(this.main).run();
            resultSet = ((BioPAXGraph)pathwayGraph).getCorrespMember(resultSet);
            for (GraphObject go : resultSet) {
                go.setHighlight(true);
            }
        }
    }
}

