/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.PathwayCommonsIOHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.BioPaxIOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.LoadBioPaxModelAction;
import org.gvt.action.MergeAction;
import org.gvt.action.OpenPathwaysAction;
import org.gvt.gui.StringInputDialog;
import org.gvt.model.GraphObject;
import org.gvt.model.biopaxl2.Actor;
import org.gvt.model.biopaxl2.Complex;
import org.patika.mada.util.XRef;

public class QueryNeighborsAction
extends Action {
    private ChisioMain main;
    private Set<XRef> refs;
    private String db;
    private boolean useSelectedNodes;
    private boolean newView;

    public QueryNeighborsAction(ChisioMain main, boolean useSelectedNodes) {
        super("Neighborhood ...");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/query-neighbors.png"));
        this.setToolTipText(this.getText());
        this.main = main;
        this.newView = true;
        this.useSelectedNodes = useSelectedNodes;
    }

    public QueryNeighborsAction(ChisioMain main, Collection<XRef> refs) {
        this(main, false);
        this.refs = new HashSet<XRef>(refs);
    }

    public boolean isUseSelectedNodes() {
        return this.useSelectedNodes;
    }

    public void setUseSelectedNodes(boolean useSelectedNodes) {
        this.useSelectedNodes = useSelectedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null || this.main.getBioPAXModel().getLevel().equals((Object)BioPAXLevel.L2)) {
            StringInputDialog dialog;
            String ids;
            if (this.refs == null) {
                this.refs = new HashSet<XRef>();
                if (this.useSelectedNodes && this.main.getViewer() != null) {
                    for (GraphObject o : this.main.getSelectedModel()) {
                        if (o instanceof Actor) {
                            this.refs.addAll(((Actor)o).getReferences());
                            continue;
                        }
                        if (!(o instanceof Complex)) continue;
                        this.refs.addAll(((Complex)o).getReferences());
                    }
                }
            }
            if (this.refs.isEmpty() && !this.useSelectedNodes && (ids = (dialog = new StringInputDialog(this.main.getShell(), "Query Neighborhood", "Enter UniProt or Entrez Gene ID", null, "Find 1-level neighborhood of the specified molecule")).open()) != null && ids.trim().length() > 0) {
                for (String id : ids.split(" ")) {
                    if (id.length() < 1) continue;
                    String dbtext = Character.isDigit(id.charAt(0)) ? "ENTREZ_GENE" : "UNIPROT";
                    this.refs.add(new XRef(dbtext + ":" + id));
                }
            }
            if (!this.refs.isEmpty()) {
                try {
                    this.main.lockWithMessage("Querying Pathway Commons Database ...");
                    PathwayCommonsIOHandler ioHandler = new PathwayCommonsIOHandler(new SimpleIOHandler());
                    HashMap<XRef, String> ref2pname = new HashMap<XRef, String>();
                    XRef xr = XRef.getFirstRef(this.refs, new String[]{"CPATH", "ENTREZ_GENE", "UNIPROT"});
                    this.refs.clear();
                    if (xr != null) {
                        this.refs.add(xr);
                    } else {
                        MessageDialog.openError(this.main.getShell(), "No Reference ID", "No CPATH, Entrez Gene or UniProt ID found to query.");
                    }
                    for (XRef ref : this.refs) {
                        if ((this.db == null || this.db.equals("CPATH")) && ref.getDb().equalsIgnoreCase("CPATH")) {
                            ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.CPATH_ID);
                        } else if ((this.db == null || this.db.equals("UNIPROT")) && ref.getDb().equalsIgnoreCase("UNIPROT")) {
                            ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.UNIPROT);
                        } else {
                            if (this.db != null && !this.db.equals("ENTREZ_GENE") || !ref.getDb().equalsIgnoreCase("ENTREZ_GENE")) continue;
                            ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.ENTREZ_GENE);
                        }
                        System.out.println("Querying neighbors for " + ref);
                        Model resultModel = null;
                        try {
                            resultModel = ioHandler.getNeighbors(ref.getRef());
                        }
                        catch (BioPaxIOException dbtext) {
                            // empty catch block
                        }
                        this.main.unlock();
                        if (resultModel != null && !resultModel.getObjects().isEmpty()) {
                            String pname = "Neighborhood for " + ref;
                            if (this.main.getBioPAXModel() != null) {
                                MergeAction merge = new MergeAction(this.main, resultModel);
                                merge.setOpenPathways(false);
                                merge.setCreateNewPathway(true);
                                merge.setUpdatePathways(false);
                                merge.setNewPathwayName(pname);
                                merge.run();
                                ref2pname.put(ref, merge.getNewPathwayName());
                                continue;
                            }
                            LoadBioPaxModelAction load = new LoadBioPaxModelAction(this.main, resultModel);
                            load.setOpenPathways(false);
                            load.setNewPathwayName(pname);
                            load.run();
                            ref2pname.put(ref, load.getLastPathwayName());
                            continue;
                        }
                        MessageDialog.openInformation(this.main.getShell(), "Not found!", "Nothing found. Make sure that the input is either a UniProt ID or an Entrez Gene ID. Gene Symbols do not work here.");
                    }
                    assert (this.main.getAllPathwayNames().containsAll(ref2pname.values())) : "New pathway names are not in allPathwayNames";
                    for (XRef ref : ref2pname.keySet()) {
                        ArrayList<String> nms = new ArrayList<String>();
                        nms.add((String)ref2pname.get(ref));
                        nms.addAll(this.main.getOpenTabNames());
                        OpenPathwaysAction opa = new OpenPathwaysAction(this.main, nms);
                        ArrayList<XRef> refL = new ArrayList<XRef>();
                        refL.add(ref);
                        opa.setRefsToHighlight(refL);
                        opa.run();
                    }
                    this.refs = null;
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MessageDialog.openError(this.main.getShell(), "Error", "An error occured during querying:\n" + e.getMessage());
                }
                finally {
                    this.main.unlock();
                }
            }
            this.refs = null;
            this.db = null;
        } else {
            MessageDialog.openError(this.main.getShell(), "Incompatible Levels", "This query is only applicable to Level 2 models.");
        }
    }
}

