/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.CPathClient;
import cpath.client.util.CPathException;
import cpath.service.GraphType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.NeighborhoodQueryParamWithEntitiesDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.GraphObject;

public class QueryPCNeighborsAction
extends QueryPCAction {
    public QueryPCNeighborsAction(ChisioMain main, boolean upstream, boolean downstream, QueryPCAction.QueryLocation qLoc) {
        super(main, upstream && downstream ? "Both Streams" : (upstream ? "Upstream" : "Downstream"), true, qLoc);
        assert (upstream || downstream);
        this.options.setUpstream(upstream);
        this.options.setDownstream(downstream);
    }

    public QueryPCNeighborsAction(ChisioMain main, QueryPCAction.QueryLocation qLoc) {
        super(main, "Neighborhood ...", false, qLoc);
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    protected String getSIFQueryType() {
        return "neighborhood";
    }

    @Override
    protected Model doQuery() throws CPathException {
        List<String> symbols = this.options.getConvertedSourceList();
        try {
            return this.getPCGraphQuery().kind(GraphType.NEIGHBORHOOD).sources(symbols).limit(this.options.getLengthLimit()).direction(this.options.isUpstream() && this.options.isDownstream() ? CPathClient.Direction.BOTHSTREAM : (this.options.isUpstream() ? CPathClient.Direction.UPSTREAM : CPathClient.Direction.DOWNSTREAM)).result();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        List<String> symbols = this.options.getConvertedSourceList();
        Set<BioPAXElement> source = this.findRelatedReferences(model, symbols);
        return QueryExecuter.runNeighborhood(source, model, this.options.getLengthLimit(), this.options.isUpstream() && this.options.isDownstream() ? Direction.BOTHSTREAM : (this.options.isUpstream() ? Direction.UPSTREAM : Direction.DOWNSTREAM), new Filter[0]);
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        return AlgoRunner.searchNeighborhood(QueryPCNeighborsAction.getSeed(graph, this.options.getConvertedSourceList()), this.options.getLengthLimit(), this.options.isUpstream(), this.options.isDownstream());
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        return new NeighborhoodQueryParamWithEntitiesDialog(this.main, this.queryLoc.isSIF());
    }

    @Override
    protected boolean canQuery() {
        List<String> symbols = this.options.getConvertedSourceList();
        this.warnForUnknownSymbols(this.options.getUnknownSymbols());
        return !symbols.isEmpty();
    }
}

