/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.util.CPathException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.gvt.ChisioMain;
import org.gvt.action.QueryPCAction;
import org.gvt.gui.AbstractQueryParamDialog;
import org.gvt.gui.GoIQueryParamWithEntitiesDialog;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.GraphObject;

public class QueryPCPathsBetweenWithMinimalLinkersAction
extends QueryPCAction {
    private String[] symbols;

    public QueryPCPathsBetweenWithMinimalLinkersAction(ChisioMain main, QueryPCAction.QueryLocation qLoc, String ... symbols) {
        super(main, "Paths Between With Minimal Linkers...", false, qLoc);
        if (qLoc == QueryPCAction.QueryLocation.FILE_MECH || qLoc == QueryPCAction.QueryLocation.PC_MECH) {
            throw new IllegalArgumentException("Cannot perform action on mechanistic graphs.");
        }
        if (symbols.length > 1) {
            this.symbols = symbols;
            String text = "Graph around " + symbols[0];
            for (int i = 1; i < symbols.length; ++i) {
                text = text + " and " + symbols[i];
            }
            this.setText(text);
        }
    }

    public QueryPCPathsBetweenWithMinimalLinkersAction(ChisioMain main, boolean useSelected, QueryPCAction.QueryLocation qLoc) {
        super(main, "Paths Between With Minimal Linkers...", useSelected, qLoc);
    }

    @Override
    public void run() {
        this.execute();
    }

    @Override
    protected Model doQuery() throws CPathException {
        throw new RuntimeException("This method should not be called!");
    }

    @Override
    protected Set<BioPAXElement> doFileQuery(Model model) {
        throw new RuntimeException("This method should not be called!");
    }

    @Override
    protected Collection<GraphObject> doSIFQuery(BasicSIFGraph graph) throws CPathException {
        return AlgoRunner.searchPathsBetweenSIFWithMinimalLinkers(QueryPCPathsBetweenWithMinimalLinkersAction.getSeed(graph, this.options.getConvertedSourceList()));
    }

    @Override
    protected AbstractQueryParamDialog getDialog() {
        if (this.symbols == null || this.symbols.length < 2) {
            return new GoIQueryParamWithEntitiesDialog(this.main, this.queryLoc.isSIF());
        }
        this.options.setSourceList(Arrays.asList(this.symbols));
        this.options.setLengthLimit(1);
        return null;
    }

    @Override
    protected boolean canQuery() {
        List<String> sourceSymbols = this.options.getConvertedSourceList();
        this.warnForUnknownSymbols(this.options.getUnknownSymbols());
        if (sourceSymbols.size() < 2) {
            this.warnForLowInput(2, sourceSymbols.size());
        }
        return sourceSymbols.size() > 1;
    }

    @Override
    protected String getNewPathwayName() {
        if (this.newPathwayName != null) {
            return super.getNewPathwayName();
        }
        if (this.symbols != null) {
            assert (this.symbols.length > 1);
            String s = this.symbols[0];
            for (int i = 1; i < this.symbols.length; ++i) {
                s = s + " -- " + this.symbols[i];
            }
            return s;
        }
        return super.getNewPathwayName();
    }

    @Override
    protected String getSIFQueryType() {
        throw new RuntimeException("Code should not reach here!");
    }

    @Override
    protected boolean highlightSeed() {
        return true;
    }
}

