/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import cpath.client.PathwayCommonsIOHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.action.LoadBioPaxModelAction;
import org.gvt.action.MergeAction;
import org.gvt.action.OpenPathwaysAction;
import org.gvt.action.UpdatePathwayAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.StringInputDialog;
import org.gvt.model.GraphObject;
import org.gvt.model.biopaxl2.Actor;
import org.gvt.model.biopaxl2.Complex;
import org.patika.mada.util.XRef;

public class QueryPathwaysAction
extends Action {
    private ChisioMain main;
    private Set<XRef> refs;
    private boolean useSelectedNodes;

    public QueryPathwaysAction(ChisioMain main, boolean useSelectedNodes) {
        super("Pathways ...");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/query-pathways.png"));
        this.setToolTipText(this.getText());
        this.main = main;
        this.useSelectedNodes = useSelectedNodes;
    }

    public QueryPathwaysAction(ChisioMain main, Collection<XRef> refs) {
        this(main, false);
        this.refs = new HashSet<XRef>(refs);
    }

    public boolean isUseSelectedNodes() {
        return this.useSelectedNodes;
    }

    public void setUseSelectedNodes(boolean useSelectedNodes) {
        this.useSelectedNodes = useSelectedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.main.getBioPAXModel() == null || this.main.getBioPAXModel().getLevel().equals((Object)BioPAXLevel.L2)) {
            block36: {
                StringInputDialog dialog;
                String ids;
                if (this.refs == null) {
                    this.refs = new HashSet<XRef>();
                    if (this.useSelectedNodes && this.main.getViewer() != null) {
                        for (GraphObject o : this.main.getSelectedModel()) {
                            if (o instanceof Actor) {
                                this.refs.addAll(((Actor)o).getReferences());
                                continue;
                            }
                            if (!(o instanceof Complex)) continue;
                            this.refs.addAll(((Complex)o).getReferences());
                        }
                    }
                }
                if (this.refs.isEmpty() && !this.useSelectedNodes && (ids = (dialog = new StringInputDialog(this.main.getShell(), "Query Pathways", "Enter UniProt or Entrez Gene ID", null, "Find pathways related to the specified molecule")).open()) != null && ids.trim().length() > 0) {
                    for (String id : ids.split(" ")) {
                        if (id.length() < 1) continue;
                        String dbtext = Character.isDigit(id.charAt(0)) ? "ENTREZ_GENE" : "UNIPROT";
                        this.refs.add(new XRef(dbtext + ":" + id));
                    }
                }
                if (!this.refs.isEmpty()) {
                    try {
                        this.main.lockWithMessage("Querying Pathway Commons Database ...");
                        PathwayCommonsIOHandler ioHandler = new PathwayCommonsIOHandler(new SimpleIOHandler());
                        HashMap<String, String> pathToID = new HashMap<String, String>();
                        ArrayList<String> resultPathways = new ArrayList<String>();
                        XRef xr = XRef.getFirstRef(this.refs, new String[]{"CPATH", "ENTREZ_GENE", "UNIPROT"});
                        this.refs.clear();
                        if (xr != null) {
                            this.refs.add(xr);
                        } else {
                            MessageDialog.openError(this.main.getShell(), "No Reference ID", "No CPATH, Entrez Gene or UniProt ID found to query.");
                        }
                        for (XRef ref : this.refs) {
                            if (ref.getDb().equalsIgnoreCase("CPATH")) {
                                ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.CPATH_ID);
                            } else if (ref.getDb().equalsIgnoreCase("UNIPROT")) {
                                ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.UNIPROT);
                            } else {
                                if (!ref.getDb().equalsIgnoreCase("ENTREZ_GENE")) continue;
                                ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.ENTREZ_GENE);
                            }
                            System.out.println("Querying pathways for " + ref);
                            List<List<String>> resultList = ioHandler.getPathways(ref.getRef());
                            this.main.unlock();
                            if (resultList.get(0).get(0).contains("xml")) {
                                MessageDialog.openError(this.main.getShell(), "Error!", "Unexpected error!");
                                resultList.clear();
                            } else if (resultList.get(1).size() == 2) {
                                resultList.clear();
                            } else {
                                resultList.remove(0);
                            }
                            for (List list : resultList) {
                                assert (list.size() == 4);
                                String cpathid = (String)list.get(3);
                                if (pathToID.containsValue(cpathid)) continue;
                                String pathwayName = (String)list.get(1);
                                String db = (String)list.get(2);
                                String line = "[" + db + "] " + pathwayName;
                                resultPathways.add(line);
                                pathToID.put(line, cpathid);
                            }
                        }
                        if (!resultPathways.isEmpty()) {
                            ArrayList selectedItems = new ArrayList();
                            ItemSelectionDialog dialog2 = new ItemSelectionDialog(this.main.getShell(), 500, "Pathway Selection Dialog", "Select pathways to retrieve", resultPathways, selectedItems, true, true, null);
                            dialog2.setMinValidSelect(1);
                            dialog2.open();
                            ArrayList<String> idList = new ArrayList<String>();
                            if (!dialog2.isCancelled()) {
                                for (String string : selectedItems) {
                                    idList.add((String)pathToID.get(string));
                                }
                            }
                            if (idList.isEmpty()) break block36;
                            try {
                                this.main.lockWithMessage("Querying Pathway Commons Database ...");
                                this.queryIDs(ioHandler, idList);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                this.main.unlock();
                            }
                            new UpdatePathwayAction(this.main, true).run();
                            OpenPathwaysAction opa = new OpenPathwaysAction(this.main);
                            opa.setRefsToHighlight(this.refs);
                            opa.run();
                            break block36;
                        }
                        if (!this.refs.isEmpty()) {
                            MessageDialog.openInformation(this.main.getShell(), "Not found!", "No pathway found. Make sure that the input is either a UniProt ID or an Entrez Gene ID. Gene Symbols and arbitrary keywords do not work here.");
                        }
                    }
                    catch (Exception e) {
                        this.refs = null;
                        e.printStackTrace();
                        MessageDialog.openError(this.main.getShell(), "Error", "An error occured during querying:\n" + e.getMessage());
                    }
                    finally {
                        this.main.unlock();
                    }
                }
            }
            this.refs = null;
        } else {
            MessageDialog.openError(this.main.getShell(), "Incompatible Levels", "This query is only applicable to Level 2 models.");
        }
    }

    private void queryIDs(PathwayCommonsIOHandler ioHandler, List<String> idList) throws IOException {
        for (String id : idList) {
            ioHandler.setInputIdType(PathwayCommonsIOHandler.ID_TYPE.CPATH_ID);
            Model resultModel = ioHandler.retrieveByID(id);
            if (resultModel == null || resultModel.getObjects().isEmpty()) continue;
            if (this.main.getBioPAXModel() != null) {
                MergeAction merge = new MergeAction(this.main, resultModel);
                merge.setOpenPathways(false);
                merge.setUpdatePathways(false);
                merge.run();
                continue;
            }
            LoadBioPaxModelAction load = new LoadBioPaxModelAction(this.main, resultModel);
            load.setOpenPathways(false);
            load.run();
        }
    }
}

