/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.action.SaveBioPAXFileAction;

public class SaveAsBioPAXFileAction
extends ChiBEAction {
    private boolean saved;

    public SaveAsBioPAXFileAction(ChisioMain chisio) {
        super("Save As ...", "icon/save-as.png", chisio);
        this.addFilterExtension("FILE_KEY", new String[]{"*.owl"});
        this.addFilterName("FILE_KEY", new String[]{"BioPAX (*.owl)"});
    }

    @Override
    public void run() {
        this.saved = false;
        if (this.main.getBioPAXModel() == null) {
            return;
        }
        String fileName = new FileChooser(this, true).choose("FILE_KEY");
        if (fileName == null) {
            return;
        }
        if (!fileName.endsWith(".owl")) {
            fileName = fileName + ".owl";
        }
        SaveBioPAXFileAction action = new SaveBioPAXFileAction(this.main, fileName);
        action.run();
        this.saved = action.isSaved();
    }

    public boolean isSaved() {
        return this.saved;
    }

    @Override
    public String getCurrentFilename() {
        String currentFilename = this.main.getOwlFileName();
        if (currentFilename != null) {
            if (!currentFilename.endsWith(".owl")) {
                if (currentFilename.indexOf(".") > 0) {
                    currentFilename = currentFilename.substring(0, currentFilename.lastIndexOf("."));
                }
                currentFilename = currentFilename + ".owl";
            }
            return currentFilename;
        }
        return null;
    }
}

