/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.BufferedWriter;
import java.io.FileWriter;
import org.eclipse.swt.widgets.MessageBox;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.model.CompoundModel;
import org.gvt.util.GraphMLWriter;

public class SaveAsGraphMLAction
extends ChiBEAction {
    public SaveAsGraphMLAction(ChisioMain chisio) {
        super("Save Pathway As GraphML ...", null, chisio);
        this.addFilterExtension("FILE_KEY", new String[]{"*.xml", "*.graphml"});
        this.addFilterName("FILE_KEY", new String[]{"XML (*.xml)", "GRAPHML (*.graphml)"});
    }

    @Override
    public void run() {
        String fileName = null;
        fileName = new FileChooser(this, true).choose("FILE_KEY");
        if (fileName == null) {
            return;
        }
        try {
            CompoundModel root = (CompoundModel)((ChsRootEditPart)this.main.getViewer().getRootEditPart().getChildren().get(0)).getModel();
            BufferedWriter xmlFile = new BufferedWriter(new FileWriter(fileName));
            GraphMLWriter writer = new GraphMLWriter();
            xmlFile.write(writer.writeXMLFile(root).toString());
            xmlFile.close();
            this.main.getEditDomain().getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.main.getShell(), 42);
            messageBox.setMessage("File cannot be saved!");
            messageBox.setText("Chisio");
            messageBox.open();
            e.printStackTrace();
        }
    }
}

