/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.io.FileOutputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.gvt.ChisioMain;
import org.gvt.action.ChiBEAction;
import org.gvt.action.FileChooser;
import org.gvt.model.basicsif.BasicSIFGraph;
import org.gvt.model.sifl3.SIFGraph;

public class SaveToSIFFileAction
extends ChiBEAction {
    public boolean isSaved = true;

    public SaveToSIFFileAction(ChisioMain chisio) {
        super("Save As SIF File ...", "icon/save-as.png", chisio);
        this.addFilterExtension("FILE_KEY", new String[]{"*.sif"});
        this.addFilterName("FILE_KEY", new String[]{"Simple Interaction Format (*.sif)"});
    }

    @Override
    public String getCurrentFilename() {
        String currentFilename = this.main.getOwlFileName();
        if (currentFilename != null && !currentFilename.endsWith(".sif")) {
            if (currentFilename.indexOf(".") > 0) {
                currentFilename = currentFilename.substring(0, currentFilename.lastIndexOf("."));
            }
            currentFilename = currentFilename + ".sif";
        }
        return currentFilename;
    }

    @Override
    public void run() {
        if (this.main.getPathwayGraph() == null) {
            return;
        }
        SIFGraph sifL3Graph = null;
        BasicSIFGraph basicSifGraph = null;
        if (this.main.getPathwayGraph().getGraphType().equals("SIF_LEVEL3")) {
            sifL3Graph = (SIFGraph)this.main.getPathwayGraph();
        } else if (this.main.getPathwayGraph().getGraphType().equals("BASIC_SIF")) {
            basicSifGraph = (BasicSIFGraph)this.main.getPathwayGraph();
        }
        if (sifL3Graph == null && basicSifGraph == null) {
            MessageDialog.openError(this.main.getShell(), "Not A Valid View!", "Only Simple Interaction Views can be written in SIF format.");
            return;
        }
        String fileName = new FileChooser(this, true).choose("FILE_KEY");
        if (fileName == null) {
            this.isSaved = false;
            return;
        }
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            if (sifL3Graph != null) {
                sifL3Graph.write(os);
            } else if (basicSifGraph != null) {
                basicSifGraph.write(os);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageBox messageBox = new MessageBox(this.main.getShell(), 42);
            messageBox.setMessage("File cannot be saved!");
            messageBox.setText("Chisio BioPAX Editor");
            messageBox.open();
        }
    }
}

