/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.gvt.ChisioMain;
import org.gvt.action.CoSELayoutAction;
import org.gvt.action.ColorWithExperimentAction;
import org.gvt.gui.ItemSelectionDialog;
import org.gvt.gui.ItemSelectionRunnable;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.EntityAssociated;
import org.gvt.model.GraphObject;
import org.gvt.util.EntityHolder;
import org.patika.mada.algorithm.AlgoRunner;
import org.patika.mada.graph.Node;
import org.patika.mada.util.CausativePath;
import org.patika.mada.util.Path;

public class SearchCausativePathsAction
extends Action {
    private ChisioMain main;
    private Set<Node> targets;
    private BioPAXGraph pathwayGraph;
    private boolean globalSearch;
    private Map<String, CausativePath> idMap;

    public SearchCausativePathsAction(ChisioMain main, boolean globalSearch) {
        super("Search Causative Paths" + (globalSearch ? " In Entire Model" : ""));
        this.setToolTipText(this.getText());
        this.main = main;
        this.globalSearch = globalSearch;
    }

    public SearchCausativePathsAction(ChisioMain main, Set<Node> targets, boolean globalSearch) {
        this(main, globalSearch);
        this.targets = targets;
    }

    @Override
    public void run() {
        BioPAXGraph graph;
        if (this.globalSearch && this.main.getBioPAXModel() == null) {
            return;
        }
        if (!this.globalSearch && this.main.getPathwayGraph() == null) {
            return;
        }
        if (this.main.getExperimentDataManager("Expression Data") == null) {
            MessageDialog.openError(this.main.getShell(), "No Expression Data Loaded!", "Load experiment data to use this feature.");
            return;
        }
        if (!this.main.getExperimentDataManager("Expression Data").isInCompareMode()) {
            MessageDialog.openError(this.main.getShell(), "Wrong Data Selection!", "Causative paths can only be searched in data comparison mode.\nGo to \"Data Selection\" and compare some of the loaded experiments.");
            return;
        }
        BioPAXGraph bioPAXGraph = graph = this.globalSearch ? BioPAXGraph.newInstance(this.main.getBioPAXModel()) : this.main.getPathwayGraph();
        if (this.targets == null) {
            this.targets = new HashSet<Node>();
            List<GraphObject> selectedModel = this.main.getSelectedModel();
            if (selectedModel != null) {
                for (GraphObject o : selectedModel) {
                    if (!(o instanceof Node)) continue;
                    this.targets.add((Node)((Object)o));
                }
                if (!this.targets.isEmpty() && this.globalSearch) {
                    Map<EntityHolder, List<Node>> entityToNodeMap = graph.getEntityToNodeMap();
                    ArrayList<Node> actors = new ArrayList<Node>(this.targets);
                    this.targets.clear();
                    for (Node actor : actors) {
                        Node corresponding = (Node)actor.getLabel("EXCISED_FROM");
                        if (!(corresponding instanceof EntityAssociated)) continue;
                        Iterator entity2 = ((EntityAssociated)corresponding).getEntity();
                        List<Node> nodeList = entityToNodeMap.get(entity2);
                        for (Node node : nodeList) {
                            this.targets.add(node);
                        }
                    }
                }
            }
        }
        int limit = 10;
        int k = 0;
        int t = 0;
        if (this.targets.isEmpty()) {
            this.targets = null;
        }
        Map<Node, Map<Integer, List<CausativePath>>> allMap = AlgoRunner.searchCausativePaths(graph, this.targets, limit, t, k);
        ArrayList<String> pathIDs = new ArrayList<String>();
        this.idMap = new HashMap<String, CausativePath>();
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Map<Integer, List<CausativePath>> integerListMap : allMap.values()) {
            for (List<CausativePath> list : integerListMap.values()) {
                paths.addAll(list);
            }
        }
        if (!paths.isEmpty() && this.globalSearch) {
            this.pathwayGraph = graph.excise(paths, false, true);
            this.pathwayGraph.setName("Causative Paths");
            this.main.createNewTab(this.pathwayGraph);
            new CoSELayoutAction(this.main).run();
            new ColorWithExperimentAction(this.main, this.pathwayGraph, "Expression Data").run();
            for (Path path : paths) {
                path.replaceElements(this.pathwayGraph);
            }
        }
        if (!this.globalSearch) {
            this.pathwayGraph = graph;
        }
        for (Node target : allMap.keySet()) {
            Map<Integer, List<CausativePath>> pathsMap = allMap.get(target);
            if (pathsMap == null) continue;
            for (int i = 1; i <= limit; ++i) {
                List<CausativePath> pathList = pathsMap.get(i);
                if (pathList == null) continue;
                for (CausativePath path : pathList) {
                    String id = path.toString();
                    if (pathIDs.contains(id)) {
                        String nextID;
                        int j = 2;
                        while (pathIDs.contains(nextID = id + " (" + j++ + ")")) {
                        }
                        id = nextID;
                    }
                    pathIDs.add(id);
                    this.idMap.put(id, path);
                }
            }
        }
        if (!pathIDs.isEmpty()) {
            ItemSelectionDialog dialog = new ItemSelectionDialog(this.main.getShell(), 250, "Path Selection Dialog", "Select path to visualize", pathIDs, new ArrayList(), false, false, new Runner());
            dialog.setUpdateUponSelection(true);
            dialog.setDoSort(false);
            Object lastItem = dialog.open();
            if (lastItem == null || !lastItem.equals("None")) {
                dialog.runAsIfSelected("None");
            }
        } else {
            MessageDialog.openInformation(this.main.getShell(), "No results!", "No causative paths found.");
        }
        this.targets = null;
        this.pathwayGraph = null;
    }

    private class Runner
    implements ItemSelectionRunnable {
        private String lastID;

        private Runner() {
        }

        @Override
        public void run(Collection selectedTerms) {
            if (selectedTerms.isEmpty()) {
                return;
            }
            String id = selectedTerms.iterator().next().toString();
            this.run(id);
        }

        public void run(String id) {
            if (id.equals(this.lastID)) {
                return;
            }
            if (this.lastID != null) {
                ((CausativePath)SearchCausativePathsAction.this.idMap.get(this.lastID)).removeInferenceData();
                ((CausativePath)SearchCausativePathsAction.this.idMap.get(this.lastID)).highlight(false);
            }
            if (id.equals("None")) {
                if (SearchCausativePathsAction.this.pathwayGraph.getLastAppliedColoring() != null) {
                    SearchCausativePathsAction.this.pathwayGraph.representDataOnActors(SearchCausativePathsAction.this.pathwayGraph.getLastAppliedColoring());
                } else {
                    SearchCausativePathsAction.this.pathwayGraph.removeRepresentations();
                }
                this.lastID = null;
                return;
            }
            ((CausativePath)SearchCausativePathsAction.this.idMap.get(id)).associateInferenceData();
            ((CausativePath)SearchCausativePathsAction.this.idMap.get(id)).highlight(true);
            SearchCausativePathsAction.this.pathwayGraph.representDataOnActors("INFERENCE_DATA_KEY");
            this.lastID = id;
        }
    }
}

