/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Collections;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsEdgeEditPart;
import org.gvt.editpart.ChsNodeEditPart;
import org.gvt.editpart.ChsRootEditPart;

public class SelectEdgesAction
extends Action {
    ChisioMain main;
    int selectionType;
    public static final int ALL_EDGES = 0;
    public static final int INTRA_GRAPH_EDGES = 1;
    public static final int INTER_GRAPH_EDGES = 2;

    public SelectEdgesAction(ChisioMain main, int selectionType) {
        this.selectionType = selectionType;
        this.main = main;
        if (selectionType == 0) {
            this.setText("Select All Edges");
        } else if (selectionType == 1) {
            this.setText("Select Intra-Graph Edges");
        } else if (selectionType == 2) {
            this.setText("Select Inter-Graph Edges");
        }
        this.setToolTipText(this.getText());
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer != null) {
            ChsRootEditPart root = (ChsRootEditPart)viewer.getRootEditPart().getChildren().get(0);
            this.main.getViewer().deselectAll();
            this.selectEdges(root);
        }
    }

    public void selectEdges(EditPart parent) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            ChsEdgeEditPart edge;
            int s;
            ChsNodeEditPart node = (ChsNodeEditPart)parent.getChildren().get(i);
            for (s = 0; s < node.getSourceConnections().size(); ++s) {
                edge = (ChsEdgeEditPart)node.getSourceConnections().get(s);
                if (edge.getEdgeModel().isIntragraph()) {
                    if (this.selectionType == 2) continue;
                    this.main.getViewer().appendSelection(edge);
                    continue;
                }
                if (this.selectionType == 1) continue;
                this.main.getViewer().appendSelection(edge);
            }
            for (s = 0; s < node.getTargetConnections().size(); ++s) {
                edge = (ChsEdgeEditPart)node.getTargetConnections().get(s);
                if (edge.getEdgeModel().isIntragraph()) {
                    if (this.selectionType == 2) continue;
                    this.main.getViewer().appendSelection(edge);
                    continue;
                }
                if (this.selectionType == 1) continue;
                this.main.getViewer().appendSelection(edge);
            }
            if (node.getChildren() == Collections.EMPTY_LIST) continue;
            this.selectEdges(node);
        }
    }
}

