/*
 * Decompiled with CFR 0.152.
 */
package org.gvt.action;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gvt.ChisioMain;
import org.gvt.editpart.ChsRootEditPart;
import org.gvt.model.BioPAXGraph;
import org.gvt.model.EdgeModel;
import org.gvt.model.GraphObject;
import org.gvt.model.NodeModel;

public class SelectHighlightedAction
extends Action {
    ChisioMain main;

    public SelectHighlightedAction(ChisioMain main) {
        super("Select Highlighted");
        this.setImageDescriptor(ImageDescriptor.createFromFile(ChisioMain.class, "icon/highlight.png"));
        this.setToolTipText(this.getText());
        this.main = main;
    }

    @Override
    public void run() {
        ScrollingGraphicalViewer viewer = this.main.getViewer();
        if (viewer == null) {
            return;
        }
        BioPAXGraph graph = this.main.getPathwayGraph();
        if (graph == null) {
            return;
        }
        HashSet<GraphObject> select = new HashSet<GraphObject>();
        for (Object o : graph.getNodes()) {
            NodeModel node = (NodeModel)o;
            if (!node.isHighlight()) continue;
            select.add(node);
        }
        for (Object o : graph.getEdges()) {
            EdgeModel edge = (EdgeModel)o;
            if (!edge.isHighlight()) continue;
            select.add(edge);
        }
        ChsRootEditPart root = (ChsRootEditPart)viewer.getRootEditPart().getChildren().get(0);
        this.selectNodes(root, select);
    }

    public void selectNodes(EditPart parent, Set<GraphObject> select) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            EditPart child = (EditPart)parent.getChildren().get(i);
            if (select.contains(child.getModel())) {
                this.main.getViewer().appendSelection(child);
            }
            if (child.getChildren() == Collections.EMPTY_LIST) continue;
            this.selectNodes(child, select);
        }
    }
}

